/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.format.impl;

import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.instance.impl.Instances;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.pipeline.Pipeline;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.ArrayUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.format.ICharFormat;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.format.impl.AbstractCharFormatInit;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.format.impl.ChineseTsCharFormat;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.format.impl.HalfWidthCharFormat;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.format.impl.LowerCaseCharFormat;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.nlp.common.format.impl.NoneCharFormat;

public final class CharFormats {
    private CharFormats() {
    }

    public static ICharFormat defaults() {
        return CharFormats.chains(CharFormats.halfWidth(), CharFormats.lowerCase());
    }

    public static ICharFormat halfWidth() {
        return Instances.singleton(HalfWidthCharFormat.class);
    }

    public static ICharFormat lowerCase() {
        return Instances.singleton(LowerCaseCharFormat.class);
    }

    public static ICharFormat none() {
        return Instances.singleton(NoneCharFormat.class);
    }

    public static ICharFormat chineseSimple() {
        return Instances.singleton(ChineseTsCharFormat.class);
    }

    public static ICharFormat chains(final ICharFormat ... formats) {
        if (ArrayUtil.isEmpty(formats)) {
            return CharFormats.none();
        }
        return new AbstractCharFormatInit(){

            @Override
            protected void init(Pipeline<ICharFormat> pipeline) {
                for (ICharFormat format : formats) {
                    pipeline.addLast(format);
                }
            }
        };
    }
}

