/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util;

import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.tuple.impl.Pair;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;

public final class PlaceholderUtil {
    public static final String DEFAULT_PLACEHOLDER_PREFIX = "${";
    public static final String DEFAULT_PLACEHOLDER_SUFFIX = "}";
    public static final String DEFAULT_VALUE_SEPARATOR = ":";

    private PlaceholderUtil() {
    }

    public static Pair<String, String> parsePlaceholder(String rawPlaceholder) {
        String trim = StringUtil.trim(rawPlaceholder);
        if (StringUtil.isEmpty(trim)) {
            return Pair.of(null, null);
        }
        if (!trim.startsWith(DEFAULT_PLACEHOLDER_PREFIX) || !trim.endsWith(DEFAULT_PLACEHOLDER_SUFFIX)) {
            return Pair.of(null, null);
        }
        String removePrefix = trim.substring(DEFAULT_PLACEHOLDER_PREFIX.length());
        String removeSuffix = removePrefix.substring(0, removePrefix.length() - DEFAULT_PLACEHOLDER_SUFFIX.length());
        int splitIndex = removeSuffix.indexOf(DEFAULT_VALUE_SEPARATOR);
        if (splitIndex < 0) {
            return Pair.of(removeSuffix, null);
        }
        String key = removeSuffix.substring(0, splitIndex);
        String defaultValue = removeSuffix.substring(splitIndex + 1);
        return Pair.of(key, defaultValue);
    }

    public static void main(String[] args) {
        System.out.println(PlaceholderUtil.parsePlaceholder(null));
        System.out.println(PlaceholderUtil.parsePlaceholder("asdfsa"));
        System.out.println(PlaceholderUtil.parsePlaceholder("${name}"));
        System.out.println(PlaceholderUtil.parsePlaceholder("${name:ruo}"));
    }
}

