/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util;

import java.io.IOException;
import java.net.ServerSocket;

public final class OsUtil {
    private static final String ARCH = System.getProperty("sun.arch.data.model");
    private static final String OS = System.getProperty("os.name").toLowerCase();

    private OsUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int getFreePort(int defaultPort) throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(defaultPort);){
            int n = serverSocket.getLocalPort();
            return n;
        }
        catch (IOException e) {
            return OsUtil.getFreePort();
        }
    }

    public static int getFreePort() throws IOException {
        try (ServerSocket serverSocket = new ServerSocket(0);){
            int n = serverSocket.getLocalPort();
            return n;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBusyPort(int port) {
        boolean ret = true;
        try (ServerSocket serverSocket = new ServerSocket(port);){
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isWindows() {
        return OS.contains("win");
    }

    public static boolean isWindowsXP() {
        return OS.contains("win") && OS.contains("xp");
    }

    public static boolean isMac() {
        return OS.contains("mac");
    }

    public static boolean isUnix() {
        return OS.contains("nix") || OS.contains("nux") || OS.contains("aix");
    }

    public static boolean isSolaris() {
        return OS.contains("sunos");
    }

    public static boolean is64() {
        return "64".equals(ARCH);
    }

    public static boolean is32() {
        return "32".equals(ARCH);
    }
}

