/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util;

import java.util.NoSuchElementException;
import java.util.Objects;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.ObjectUtil;

public final class Optional<T> {
    private static final Optional<?> EMPTY = new Optional();
    private final T value;

    private Optional() {
        this.value = null;
    }

    public static <T> Optional<T> empty() {
        Optional<?> t = EMPTY;
        return t;
    }

    private Optional(T value) {
        this.value = Objects.requireNonNull(value);
    }

    public static <T> Optional<T> of(T value) {
        return new Optional<T>(value);
    }

    public static <T> Optional<T> ofNullable(T value) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(value);
    }

    public T get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public <R> R getCastOrNull(Class<R> rClass) {
        if (ObjectUtil.isNotNull(this.value)) {
            return (R)this.value;
        }
        return null;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public boolean isNotPresent() {
        return this.value == null;
    }

    public <X extends Throwable> T orElseThrow(X throwable) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw throwable;
    }

    public T orElseNull() {
        if (this.value != null) {
            return this.value;
        }
        return null;
    }

    public T orDefault(T defaultVal) {
        if (this.value != null) {
            return this.value;
        }
        return defaultVal;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Optional)) {
            return false;
        }
        Optional other = (Optional)obj;
        return Objects.equals(this.value, other.value);
    }

    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    public String toString() {
        return this.value != null ? String.format("Optional[%s]", this.value) : "Optional.empty";
    }
}

