/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.response.exception.CommonRuntimeException;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.ObjectUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;

public final class DateUtil {
    public static final String PURE_DATE_FORMAT = "yyyyMMdd";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String DATE_ZH_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5";
    public static final String PURE_TIME_FORMAT = "HHmmss";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String TIME_ZH_FORMAT = "HH\u65f6mm\u5206ss\u79d2";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATE_TIME_SEC_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIMESTAMP_FORMAT_17 = "yyyyMMddHHmmssSSS";
    public static final String TIMESTAMP_FORMAT_14 = "yyyyMMddHHmmss";
    public static final String TIMESTAMP_FORMAT_15 = "yyMMddHHmmssSSS";

    private DateUtil() {
    }

    public static String getDateFormat(Date date, String format) {
        if (ObjectUtil.isNull(date)) {
            return null;
        }
        return new SimpleDateFormat(format).format(date);
    }

    public static String formatDate(Date date, String format) {
        return DateUtil.getDateFormat(date, format);
    }

    public static Date parseDate(String string, String format) {
        return DateUtil.getFormatDate(string, format);
    }

    public static String getDateFormat17(Date date) {
        return DateUtil.getDateFormat(date, TIMESTAMP_FORMAT_17);
    }

    public static String getDateFormat14(Date date) {
        return DateUtil.getDateFormat(date, TIMESTAMP_FORMAT_14);
    }

    public static Date getFormatDate(String dateStr, String format) {
        if (StringUtil.isEmptyTrim(dateStr)) {
            return null;
        }
        try {
            return new SimpleDateFormat(format).parse(dateStr);
        }
        catch (ParseException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Date getFormatDate17(String dateStr) {
        return DateUtil.getFormatDate(dateStr, TIMESTAMP_FORMAT_17);
    }

    public static Date getFormatDate14(String dateStr) {
        return DateUtil.getFormatDate(dateStr, TIMESTAMP_FORMAT_14);
    }

    public static String getCurrentDateStr() {
        Date now = new Date();
        return new SimpleDateFormat(DATE_FORMAT).format(now);
    }

    public static String getCurrentDatePureStr() {
        Date now = new Date();
        return new SimpleDateFormat(PURE_DATE_FORMAT).format(now);
    }

    public static String getYesterdayPureStr() {
        Date now = new Date();
        Date yesterday = DateUtil.addDay(now, -1);
        return new SimpleDateFormat(PURE_DATE_FORMAT).format(yesterday);
    }

    public static String getCurrentTimeStampStr() {
        Date now = new Date();
        return new SimpleDateFormat(TIMESTAMP_FORMAT_17).format(now);
    }

    public static String getCurrentTime17() {
        Date now = new Date();
        return new SimpleDateFormat(TIMESTAMP_FORMAT_17).format(now);
    }

    public static String getCurrentTime14() {
        Date now = new Date();
        return new SimpleDateFormat(TIMESTAMP_FORMAT_14).format(now);
    }

    public static String getCurrentTimeStampStr15() {
        Date now = new Date();
        return new SimpleDateFormat(TIMESTAMP_FORMAT_15).format(now);
    }

    public static String getCurrentTimeMills() {
        return String.valueOf(System.currentTimeMillis());
    }

    public static String getCurrentDateTimeStr() {
        Date now = new Date();
        return new SimpleDateFormat(DATE_TIME_FORMAT).format(now);
    }

    public static long convertMsToNs(long ms) {
        return TimeUnit.NANOSECONDS.convert(ms > 0L ? ms : 0L, TimeUnit.MILLISECONDS);
    }

    public static Date now() {
        return new Date();
    }

    public static long costTimeInMills(Date start, Date end) {
        return end.getTime() - start.getTime();
    }

    public static void sleep(long pauseMills) {
        DateUtil.sleep(TimeUnit.MILLISECONDS, pauseMills);
    }

    public static void sleep(TimeUnit unit, long timeout) {
        if (timeout <= 0L) {
            return;
        }
        try {
            unit.sleep(timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new CommonRuntimeException(e);
        }
    }

    public static Date fromSql(java.sql.Date date) {
        if (null == date) {
            return null;
        }
        return new Date(date.getTime());
    }

    public static java.sql.Date toSqlDate(Date date) {
        if (null == date) {
            return null;
        }
        return new java.sql.Date(date.getTime());
    }

    public static Time toSqlTime(Date date) {
        if (null == date) {
            return null;
        }
        return new Time(date.getTime());
    }

    public static Timestamp toSqlTimestamp(Date date) {
        if (null == date) {
            return null;
        }
        return new Timestamp(date.getTime());
    }

    public static Date addYear(Date date, int year) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(1, year);
        return calendar.getTime();
    }

    public static Date addMonth(Date date, int month) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(2, month);
        return calendar.getTime();
    }

    public static Date addDay(Date date, int day) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(5, day);
        return calendar.getTime();
    }

    public static Date addHour(Date date, int hour) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(11, hour);
        return calendar.getTime();
    }

    public static Date addMinute(Date date, int minute) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(12, minute);
        return calendar.getTime();
    }

    public static Date addSecond(Date date, int second) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        ((Calendar)calendar).add(13, second);
        return calendar.getTime();
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static Integer getDateHours(Date date) {
        if (date == null) {
            return null;
        }
        return date.getHours();
    }

    public static int getCurrentDateHours() {
        Date now = DateUtil.getCurrentDate();
        return DateUtil.getDateHours(now);
    }

    public static boolean isAm() {
        int hours = DateUtil.getCurrentDateHours();
        return 0 <= hours && hours <= 12;
    }

    public static boolean isPm() {
        return !DateUtil.isAm();
    }

    public static String slimDate(String yyyyMMddStr) {
        Date date = DateUtil.getFormatDate(yyyyMMddStr, PURE_DATE_FORMAT);
        String slimDate = DateUtil.getDateFormat(date, "MM.dd");
        if (slimDate.startsWith("0")) {
            return slimDate.substring(1);
        }
        return slimDate;
    }

    public static List<String> getDateRangeList(String begin, String end) {
        Date bDate = DateUtil.getFormatDate(begin, PURE_DATE_FORMAT);
        Date eDate = DateUtil.getFormatDate(end, PURE_DATE_FORMAT);
        List<Date> dateList = DateUtil.getDateRangeList(bDate, eDate);
        ArrayList<String> resultList = new ArrayList<String>(dateList.size());
        for (Date dt : dateList) {
            String dateStr = DateUtil.getDateFormat(dt, PURE_DATE_FORMAT);
            resultList.add(dateStr);
        }
        return resultList;
    }

    public static List<Date> getDateRangeList(Date startDate, Date endDate) {
        Date nowDate;
        ArgUtil.notNull(startDate, "startDate");
        ArgUtil.notNull(endDate, "endDate");
        ArrayList<Date> resultList = new ArrayList<Date>();
        if (startDate.compareTo(endDate) > 0) {
            return resultList;
        }
        resultList.add(startDate);
        for (int i = 1; i < Integer.MAX_VALUE && (nowDate = DateUtil.addDay(startDate, i)).compareTo(endDate) <= 0; ++i) {
            resultList.add(nowDate);
        }
        return resultList;
    }

    public static String getDifferDate(Date date, int differ) {
        Date differDate = DateUtil.addDay(date, differ);
        return DateUtil.getDateFormat(differDate, PURE_DATE_FORMAT);
    }

    public static String changeFormat(String dateOld, String oldFormat, String newFormat) {
        if (StringUtil.isEmpty(dateOld)) {
            return dateOld;
        }
        Date date = DateUtil.parseDate(dateOld, oldFormat);
        return DateUtil.formatDate(date, newFormat);
    }

    public static long getDistanceDays(String str1, String str2) {
        Date one = DateUtil.parseDate(str1, PURE_DATE_FORMAT);
        Date two = DateUtil.parseDate(str2, PURE_DATE_FORMAT);
        return DateUtil.getDistanceDays(one, two);
    }

    public static long getDistanceDays(Date one, Date two) {
        long time2;
        long time1 = one.getTime();
        long diff = time1 < (time2 = two.getTime()) ? time2 - time1 : time1 - time2;
        return diff / 86400000L;
    }

    public static Date toDate(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        return calendar.getTime();
    }

    public static Date toDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof Calendar) {
            Calendar calendar = (Calendar)object;
            return DateUtil.toDate(calendar);
        }
        throw new ClassCastException();
    }
}

