/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.time.impl;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.time.Time;

public class ScheduledSystemTime
implements Time {
    private final long period;
    private final AtomicLong now;

    private ScheduledSystemTime(long period) {
        this.period = period;
        this.now = new AtomicLong(System.currentTimeMillis());
        this.scheduleClockUpdating();
    }

    public ScheduledSystemTime() {
        this(1L);
    }

    private void scheduleClockUpdating() {
        ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, "System Clock");
                thread.setDaemon(true);
                return thread;
            }
        });
        scheduler.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                ScheduledSystemTime.this.now.incrementAndGet();
            }
        }, this.period, this.period, TimeUnit.MILLISECONDS);
    }

    @Override
    public long time() {
        return this.now.get();
    }
}

