/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.nio;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.response.exception.CommonRuntimeException;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.guava.Guavas;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.ObjectUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.CollectionUtil;

public final class PathUtil {
    public static final Path ROOT_PATH = Paths.get("/", new String[0]);

    private PathUtil() {
    }

    public static String getRelativePath(Path parentPath, Path path) {
        String pathStr = path.toString();
        if (ObjectUtil.isNull(parentPath)) {
            return pathStr;
        }
        if (parentPath.toString().length() <= 1) {
            return pathStr;
        }
        String parentPathStr = parentPath.toString();
        if (pathStr.startsWith(parentPathStr)) {
            return pathStr.substring(parentPathStr.length() + 1);
        }
        return pathStr;
    }

    public static Path getPublicParentPath(List<Path> pathList) {
        if (pathList.size() == 1) {
            return PathUtil.getParentPath(pathList.get(0));
        }
        ArrayList<List<String>> pathStrList = new ArrayList<List<String>>(pathList.size());
        for (Path path : pathList) {
            List<String> stringList = CollectionUtil.toStringList(PathUtil.getParentPaths(path));
            pathStrList.add(stringList);
        }
        List<String> publicParentPathStrs = PathUtil.retainAll(pathStrList);
        String maxLengthParent = PathUtil.getMaxLength(publicParentPathStrs);
        return Paths.get(maxLengthParent, new String[0]);
    }

    private static String getMaxLength(List<String> stringList) {
        String result = "";
        for (String string : stringList) {
            if (string.length() <= result.length()) continue;
            result = string;
        }
        return result;
    }

    public static List<Path> getParentPaths(Path path) {
        if (ObjectUtil.isNull(path)) {
            return Collections.emptyList();
        }
        ArrayList<Path> pathList = new ArrayList<Path>();
        Path parentPath = path.getParent();
        while (ObjectUtil.isNotNull(parentPath)) {
            pathList.add(parentPath);
            parentPath = parentPath.getParent();
        }
        if (CollectionUtil.isEmpty(pathList)) {
            pathList.add(ROOT_PATH);
        }
        return pathList;
    }

    public static Path getParentPath(Path path) {
        Path parentPath = path.getParent();
        if (ObjectUtil.isNull(parentPath)) {
            return ROOT_PATH;
        }
        return parentPath;
    }

    public static List<String> retainAll(List<List<String>> collectionList) {
        if (CollectionUtil.isEmpty(collectionList)) {
            return Collections.emptyList();
        }
        if (collectionList.size() == 1) {
            return collectionList.get(0);
        }
        List<String> result = collectionList.get(0);
        for (int i = 1; i < collectionList.size(); ++i) {
            result.retainAll((Collection)collectionList.get(i));
        }
        return result;
    }

    public static List<Path> getPathList(Path rootPath) {
        final ArrayList<Path> pathList = new ArrayList<Path>();
        try {
            if (Files.isDirectory(rootPath, new LinkOption[0])) {
                Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        pathList.add(file);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        pathList.add(dir);
                        return FileVisitResult.CONTINUE;
                    }
                });
            } else {
                pathList.add(rootPath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return pathList;
    }

    public static List<Path> getPathList(String dir, String glob) {
        LinkedList<Path> list = new LinkedList<Path>();
        Path root = Paths.get(dir, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, glob);){
            for (Path path : stream) {
                list.add(path);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static List<Path> getDirFileNames(String dir, String glob) {
        LinkedList<Path> list = new LinkedList<Path>();
        Path root = Paths.get(dir, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, glob);){
            for (Path path : stream) {
                list.add(path.getFileName());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static List<Path> getAllDirFileNames(String dir) {
        return PathUtil.getDirFileNames(dir, "*.*");
    }

    public static List<String> getDirFileNameStrs(String dir, String glob) {
        LinkedList<String> list = new LinkedList<String>();
        Path root = Paths.get(dir, new String[0]);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(root, glob);){
            for (Path path : stream) {
                list.add(path.getFileName().toString());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return list;
    }

    public static String getPath() {
        return System.getProperty("user.dir");
    }

    public static String getRootPath() {
        return Class.class.getClass().getResource("/").getPath();
    }

    public static String getAppRootPath() {
        File emptyFile = new File("");
        return emptyFile.getAbsolutePath();
    }

    public static String getAppResourcesPath() {
        return PathUtil.getAppRootPath() + "/src/main/resources";
    }

    public static String getAppTestResourcesPath() {
        return PathUtil.getAppRootPath() + "/src/test/resources";
    }

    public static String getRootPath(Class clazz) {
        String uriPath = clazz.getResource("/").toString();
        return uriPath.replace("filelist:", "").replace("target/classes/", "src/main/java/");
    }

    public static String getPath(Class clazz) {
        String uriPath = clazz.getResource("").toString();
        return uriPath.replace("filelist:", "").replace("target/classes/", "src/main/java/");
    }

    public static String packageToPath(String packagePath) {
        return packagePath.replaceAll("\\.", "/");
    }

    public static List<String> readAllLines(String pathStr) {
        return PathUtil.readAllLines(pathStr, "UTF-8");
    }

    public static List<String> readAllLines(String pathStr, String charset) {
        return PathUtil.readAllLines(pathStr, charset, 0, Integer.MAX_VALUE);
    }

    public static List<String> readAllLines(String pathStr, String charset, int startIndex, int endIndex) {
        ArgUtil.notEmpty(pathStr, "pathStr");
        ArgUtil.notEmpty(charset, "charset");
        ArgUtil.assertTrue(endIndex >= startIndex, "endIndex >= startIndex");
        Path path = Paths.get(pathStr, new String[0]);
        try {
            List<String> allLines = Files.readAllLines(path, Charset.forName(charset));
            int size = allLines.size();
            if (endIndex > size) {
                endIndex = size;
            }
            return allLines.subList(startIndex, endIndex);
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static void writeLines(String pathStr, String ... lines) {
        List<String> stringList = Guavas.newArrayList(lines);
        PathUtil.writeLines(pathStr, stringList, "UTF-8", new OpenOption[0]);
    }

    public static void writeLines(String pathStr, Collection<String> lines) {
        PathUtil.writeLines(pathStr, lines, "UTF-8", new OpenOption[0]);
    }

    public static void appendLines(String pathStr, String ... lines) {
        List<String> stringList = Guavas.newArrayList(lines);
        PathUtil.writeLines(pathStr, stringList, "UTF-8", StandardOpenOption.APPEND);
    }

    public static void appendLines(String pathStr, Collection<String> lines) {
        PathUtil.writeLines(pathStr, lines, "UTF-8", StandardOpenOption.APPEND);
    }

    public static void writeLines(String pathStr, Collection<String> lines, String charset, OpenOption ... openOptions) {
        ArgUtil.notEmpty(pathStr, "pathStr");
        ArgUtil.notEmpty(charset, "charset");
        ArgUtil.notEmpty(lines, "lines");
        try {
            Path path = Paths.get(pathStr, new String[0]);
            Files.write(path, lines, Charset.forName(charset), openOptions);
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }
}

