/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.net;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.response.exception.CommonRuntimeException;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.regex.RegexUtil;

public final class NetUtil {
    public static final String LOCALHOST = "127.0.0.1";
    private static final String LOCAL_HOST;

    private NetUtil() {
    }

    public static String getLocalHost() {
        return LOCAL_HOST;
    }

    public static boolean isReachable(String remoteInetAddress) {
        return NetUtil.isReachable(remoteInetAddress, 5000);
    }

    public static boolean isReachable(String remoteInetAddress, int timeoutInMills) {
        boolean reachable = false;
        try {
            InetAddress address = InetAddress.getByName(remoteInetAddress);
            reachable = address.isReachable(timeoutInMills);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return reachable;
    }

    public static void assertOnLine() {
        String address = "translate.google.cn";
        try {
            InetAddress inetAddress = InetAddress.getByName("translate.google.cn");
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("The net work is broken, check your network or set isCommentWhenNetworkBroken=true.");
        }
    }

    public static String getLocalIp() {
        InetAddress inetAddress = NetUtil.findLocalAddress();
        if (inetAddress == null) {
            return null;
        }
        String ip = inetAddress.getHostAddress();
        if (RegexUtil.isIp(ip)) {
            return ip;
        }
        return null;
    }

    private static InetAddress findLocalAddress() {
        String preferNamePrefix = "bond0";
        String defaultNicList = "bond0,eth0,em0,en0,em1,br0,eth1,em2,en1,eth2,em3,en2,eth3,em4,en3";
        InetAddress resultAddress = null;
        HashMap<String, NetworkInterface> candidateInterfaces = new HashMap<String, NetworkInterface>();
        try {
            String[] allInterfaces = NetworkInterface.getNetworkInterfaces();
            while (allInterfaces.hasMoreElements()) {
                NetworkInterface nic = allInterfaces.nextElement();
                if (!nic.isUp() || !nic.supportsMulticast()) continue;
                String name = nic.getName();
                if (name.startsWith(preferNamePrefix)) {
                    resultAddress = NetUtil.findAvailableAddress(nic);
                    if (resultAddress == null) continue;
                    return resultAddress;
                }
                candidateInterfaces.put(name, nic);
            }
            for (String nifName : defaultNicList.split(",")) {
                NetworkInterface nic = (NetworkInterface)candidateInterfaces.get(nifName);
                if (nic == null || (resultAddress = NetUtil.findAvailableAddress(nic)) == null) continue;
                return resultAddress;
            }
            return null;
        }
        catch (SocketException e) {
            throw new CommonRuntimeException(e);
        }
    }

    private static InetAddress findAvailableAddress(NetworkInterface nic) {
        Enumeration<InetAddress> inetAddresses = nic.getInetAddresses();
        while (inetAddresses.hasMoreElements()) {
            InetAddress inetAddress = inetAddresses.nextElement();
            if (inetAddress instanceof Inet6Address || inetAddress.isLoopbackAddress()) continue;
            return inetAddress;
        }
        return null;
    }

    static {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new CommonRuntimeException(e);
        }
        LOCAL_HOST = address.getHostAddress();
    }
}

