/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.net;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.response.exception.CommonRuntimeException;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.FileUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.MapUtil;

public final class HttpUtil {
    public static final String GET = "GET";
    public static final String POST = "POST";

    private HttpUtil() {
    }

    public static String getRequest(String requestUrl) {
        return HttpUtil.request(requestUrl, GET);
    }

    public static String postRequest(String requestUrl) {
        return HttpUtil.request(requestUrl, POST);
    }

    public static String request(String requestUrl, String requestMethod) {
        return HttpUtil.request(requestUrl, requestMethod, "UTF-8", null);
    }

    public static String request(String requestUrl, String requestMethod, Map<String, String> headerMap) {
        return HttpUtil.request(requestUrl, requestMethod, "UTF-8", headerMap);
    }

    public static String request(String requestUrl, String requestMethod, String charset, Map<String, String> headerMap) {
        StringBuilder buffer = new StringBuilder();
        try {
            URL url = new URL(requestUrl);
            HttpURLConnection httpUrlConn = (HttpURLConnection)url.openConnection();
            httpUrlConn.setDoOutput(true);
            httpUrlConn.setDoInput(true);
            httpUrlConn.setUseCaches(false);
            httpUrlConn.setRequestMethod(requestMethod);
            if (MapUtil.isNotEmpty(headerMap)) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    httpUrlConn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            if (GET.equalsIgnoreCase(requestMethod)) {
                httpUrlConn.connect();
            }
            InputStream inputStream = httpUrlConn.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                buffer.append(line);
            }
            bufferedReader.close();
            inputStreamReader.close();
            inputStream.close();
            httpUrlConn.disconnect();
            return buffer.toString();
        }
        catch (Exception e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Map<String, String> buildHeaderMap(String filePath) {
        List<String> stringList = FileUtil.readAllLines(filePath);
        HashMap<String, String> map = new HashMap<String, String>(stringList.size());
        for (String line : stringList) {
            int index = line.indexOf(":");
            String key = line.substring(0, index).trim();
            String value = line.substring(index + 1).trim();
            map.put(key, value);
        }
        return map;
    }

    public static void download(String remoteUrl, String localUrl) {
        HttpUtil.download(remoteUrl, localUrl, null);
    }

    public static void download(String remoteUrl, String localUrl, Map<String, String> headerMap) {
        ArgUtil.notEmpty(remoteUrl, "remoteUrl");
        ArgUtil.notEmpty(localUrl, "localUrl");
        try {
            URL url = new URL(remoteUrl);
            URLConnection conn = url.openConnection();
            if (MapUtil.isNotEmpty(headerMap)) {
                for (Map.Entry<String, String> entry : headerMap.entrySet()) {
                    String key = entry.getKey();
                    String value = entry.getValue();
                    conn.setRequestProperty(key, value);
                }
            }
            try (DataInputStream dataInputStream = new DataInputStream(conn.getInputStream());
                 FileOutputStream fileOutputStream = new FileOutputStream(new File(localUrl));){
                int length;
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((length = dataInputStream.read(buffer)) > 0) {
                    output.write(buffer, 0, length);
                }
                fileOutputStream.write(output.toByteArray());
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }
}

