/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.reflect;

import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.response.exception.CommonRuntimeException;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.filter.IFilter;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.handler.IHandler;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.guava.Guavas;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.ObjectUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.reflect.PrimitiveUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.ArrayUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.CollectionUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.MapUtil;

public final class ClassUtil {
    public static final String SERIAL_VERSION_UID = "serialVersionUID";

    private ClassUtil() {
    }

    public static String getClassVar(String className) {
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    public static List<Field> getAllFieldList(Class clazz) {
        ArrayList<Field> allFieldList = new ArrayList<Field>();
        for (Class tempClass = clazz; tempClass != null; tempClass = tempClass.getSuperclass()) {
            allFieldList.addAll(Guavas.newArrayList(tempClass.getDeclaredFields()));
        }
        List<Field> resultList = Guavas.newArrayList(allFieldList.size());
        for (Field field : allFieldList) {
            String fieldName = field.getName();
            if (SERIAL_VERSION_UID.equals(fieldName)) continue;
            field.setAccessible(true);
            resultList.add(field);
        }
        return resultList;
    }

    public static List<Field> getModifyableFieldList(Class clazz) {
        List<Field> allFieldList = ClassUtil.getAllFieldList(clazz);
        if (CollectionUtil.isEmpty(allFieldList)) {
            return allFieldList;
        }
        return CollectionUtil.filterList(allFieldList, new IFilter<Field>(){

            @Override
            public boolean filter(Field field) {
                return Modifier.isFinal(field.getModifiers());
            }
        });
    }

    public static Map<String, Field> getAllFieldMap(Class clazz) {
        List<Field> fieldList = ClassUtil.getAllFieldList(clazz);
        return MapUtil.toMap(fieldList, new IHandler<Field, String>(){

            @Override
            public String handle(Field field) {
                return field.getName();
            }
        });
    }

    @Deprecated
    public static Map<String, Object> beanToMap(Object bean) {
        try {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            List<Field> fieldList = ClassUtil.getAllFieldList(bean.getClass());
            for (Field field : fieldList) {
                String fieldName = field.getName();
                Object fieldValue = field.get(bean);
                map.put(fieldName, fieldValue);
            }
            return map;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Method> getAllFieldsReadMethods(Class clazz) throws IntrospectionException {
        List<Field> fieldList = ClassUtil.getAllFieldList(clazz);
        if (CollectionUtil.isEmpty(fieldList)) {
            return Collections.emptyList();
        }
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Field field : fieldList) {
            PropertyDescriptor pd = new PropertyDescriptor(field.getName(), clazz);
            Method getMethod = pd.getReadMethod();
            methods.add(getMethod);
        }
        return methods;
    }

    public static ClassLoader currentClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public static Class getClass(String className) {
        ArgUtil.notEmpty(className, "className");
        try {
            return ClassUtil.currentClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Method getMethod(Class clazz, String methodName, Class ... paramTypes) {
        ArgUtil.notNull(clazz, "clazz");
        ArgUtil.notEmpty(methodName, "methodName");
        try {
            return clazz.getMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method[] methods;
        ArgUtil.notNull(clazz, "clazz");
        ArgUtil.notEmpty(methodName, "methodName");
        for (Method method : methods = clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new CommonRuntimeException("\u5bf9\u5e94\u65b9\u6cd5\u4e0d\u5b58\u5728!");
    }

    public static Constructor getConstructor(Class clazz, Class ... paramTypes) {
        ArgUtil.notNull(clazz, "clazz");
        try {
            return clazz.getConstructor(paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static List<Method> getMethodList(Class tClass) {
        ArgUtil.notNull(tClass, "tClass");
        Method[] methods = tClass.getMethods();
        return ArrayUtil.toList(methods);
    }

    public static List<Method> getDeclaredMethodList(Class tClass) {
        ArgUtil.notNull(tClass, "tClass");
        Method[] methods = tClass.getDeclaredMethods();
        return ArrayUtil.toList(methods);
    }

    public static List<Class> getAllSuperClass(Class clazz) {
        ArgUtil.notNull(clazz, "clazz");
        Set classSet = Guavas.newHashSet();
        for (Class tempClass = clazz.getSuperclass(); tempClass != null; tempClass = tempClass.getSuperclass()) {
            classSet.add(tempClass);
        }
        return Guavas.newArrayList(classSet);
    }

    public static List<Class> getAllInterfaces(Class clazz) {
        ArgUtil.notNull(clazz, "clazz");
        Set<Object> classSet = Guavas.newHashSet();
        Object[] interfaces = clazz.getInterfaces();
        if (ArrayUtil.isNotEmpty(interfaces)) {
            classSet.addAll(ArrayUtil.toList(interfaces));
            for (Object interfaceClass : interfaces) {
                List<Class> classList = ClassUtil.getAllInterfaces((Class)interfaceClass);
                if (!CollectionUtil.isNotEmpty(classList)) continue;
                classSet.addAll(classList);
            }
        }
        return Guavas.newArrayList(classSet);
    }

    public static List<Class> getAllInterfacesAndSuperClass(Class clazz) {
        ArgUtil.notNull(clazz, "clazz");
        Set<Class> classSet = Guavas.newHashSet();
        classSet.addAll(ClassUtil.getAllInterfaces(clazz));
        classSet.addAll(ClassUtil.getAllSuperClass(clazz));
        return Guavas.newArrayList(classSet);
    }

    public static boolean isAssignable(Class<?> sourceType, Class<?> targetType) {
        if (ObjectUtil.isNull(sourceType) || ObjectUtil.isNull(targetType)) {
            return false;
        }
        if (sourceType.isAssignableFrom(targetType)) {
            return true;
        }
        if (sourceType.isPrimitive()) {
            Class<?> resolvedPrimitive = PrimitiveUtil.getPrimitiveType(targetType);
            return sourceType == resolvedPrimitive;
        }
        Class<?> resolvedPrimitive = PrimitiveUtil.getPrimitiveType(targetType);
        return resolvedPrimitive != null && sourceType.isAssignableFrom(resolvedPrimitive);
    }

    public static boolean instanceOf(Class<?> clazz, String interfaceName) {
        ArgUtil.notNull(clazz, "clazz");
        ArgUtil.notEmpty(interfaceName, "interfaceName");
        if (clazz.getName().equals(interfaceName)) {
            return true;
        }
        List<Class> interfaces = ClassUtil.getAllInterfaces(clazz);
        if (CollectionUtil.isEmpty(interfaces)) {
            return false;
        }
        for (Class clazzInter : interfaces) {
            String name = clazzInter.getName();
            if (!name.equals(interfaceName)) continue;
            return true;
        }
        return false;
    }
}

