/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.big;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.big.BigFileStringHandlerContext;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.big.BigFileStringHandlerPrint;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.big.BigFileStringHandlerSegment;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.big.IBigFileStringHandler;

public final class BigFileUtil {
    private BigFileUtil() {
    }

    public static void read(String filePath) {
        BigFileUtil.read(filePath, new BigFileStringHandlerPrint());
    }

    public static void read(String filePath, IBigFileStringHandler handler) {
        BigFileUtil.read(filePath, handler, "UTF-8");
    }

    public static void read(String filePath, IBigFileStringHandler handler, String charsetName) {
        BigFileUtil.read(filePath, handler, charsetName, 0L);
    }

    public static void read(String filePath, IBigFileStringHandler handler, String charsetName, long posPointer) {
        try {
            String s;
            RandomAccessFile raf = new RandomAccessFile(new File(filePath), "r");
            raf.seek(posPointer);
            int index = 0;
            BigFileStringHandlerContext context = new BigFileStringHandlerContext();
            context.setFilePath(filePath);
            context.setCharset(charsetName);
            while ((s = raf.readLine()) != null) {
                byte[] bytes = s.getBytes("ISO-8859-1");
                String line = new String(bytes, charsetName);
                context.setIndex(index);
                context.setLine(line);
                context.setFilePointer(raf.getFilePointer());
                handler.handle(context);
                ++index;
            }
            raf.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void segFile(String filePath) {
        BigFileUtil.segFile(filePath, 100000);
    }

    public static void segFile(String filePath, int limitSize) {
        BigFileUtil.segFile(filePath, limitSize, "UTF-8");
    }

    public static void segFile(String filePath, int limitSize, String charsetName) {
        BigFileUtil.segFile(filePath, limitSize, charsetName, 0L);
    }

    public static void segFile(String filePath, int limitSize, String charsetName, long posPointer) {
        BigFileStringHandlerSegment stringHandler = new BigFileStringHandlerSegment(limitSize);
        BigFileUtil.read(filePath, stringHandler, charsetName, posPointer);
    }
}

