/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.response.exception.CommonRuntimeException;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.handler.IMapHandler;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.io.MarkdownFileWalker;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.ArrayUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.MapUtil;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public final class FileUtil {
    private FileUtil() {
    }

    public static String getFileContent(String filePath) {
        return FileUtil.getFileContent(filePath, "UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileContent(String filePath, String charset) {
        File file = new File(filePath);
        if (!file.exists()) throw new CommonRuntimeException(filePath + " is not exists!");
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = FileUtil.getFileContent(inputStream, charset);
            return string;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static String getFileContent(InputStream inputStream) {
        return FileUtil.getFileContent(inputStream, "UTF-8");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileContent(File file, String charset) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = FileUtil.getFileContent(inputStream, charset);
            return string;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileContent(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            String string = FileUtil.getFileContent(inputStream);
            return string;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static String getFileContent(InputStream inputStream, String charset) {
        Charset charsetVal = Charset.forName(charset);
        return FileUtil.getFileContent(inputStream, 0, Integer.MAX_VALUE, charsetVal);
    }

    public static String getFileContent(InputStream inputStream, int startIndex, int endIndex, Charset charset) {
        try {
            endIndex = Math.min(endIndex, inputStream.available());
            startIndex = Math.max(0, startIndex);
            inputStream.skip(startIndex);
            int count = endIndex - startIndex;
            byte[] bytes = new byte[count];
            for (int readCount = 0; readCount < count && readCount != -1; readCount += inputStream.read(bytes, readCount, count - readCount)) {
            }
            String string = new String(bytes, charset);
            return string;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String getSuffix(String fileName) {
        return fileName.substring(fileName.lastIndexOf(46) + 1);
    }

    public static List<String> getFileContentEachLine(String filePath, int initLine) {
        File file = new File(filePath);
        return FileUtil.getFileContentEachLine(file, initLine);
    }

    public static List<String> getFileContentEachLine(String filePath) {
        File file = new File(filePath);
        return FileUtil.getFileContentEachLine(file, 0);
    }

    public static List<String> getFileContentEachLineTrim(String filePath, int initLine) {
        List<String> stringList = FileUtil.getFileContentEachLine(filePath, initLine);
        LinkedList<String> resultList = new LinkedList<String>();
        for (String string : stringList) {
            resultList.add(string.trim());
        }
        return resultList;
    }

    public static List<String> getFileContentEachLine(File file) {
        return FileUtil.getFileContentEachLine(file, 0);
    }

    public static List<String> getFileContentEachLine(File file, int initLine) {
        LinkedList<String> contentList = new LinkedList<String>();
        if (!file.exists()) {
            return contentList;
        }
        String charset = "UTF-8";
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String dataEachLine;
            int lineNo;
            for (lineNo = 0; lineNo < initLine; ++lineNo) {
                String string = bufferedReader.readLine();
            }
            while ((dataEachLine = bufferedReader.readLine()) != null) {
                ++lineNo;
                if (Objects.equals("", dataEachLine)) continue;
                contentList.add(dataEachLine);
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
        return contentList;
    }

    @Deprecated
    public static List<String> getFileContentEachLine(File file, int initLine, int endLine, String charset) {
        LinkedList<String> contentList = new LinkedList<String>();
        if (!file.exists()) {
            return contentList;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);
             InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String dataEachLine;
            int lineNo;
            for (lineNo = 0; lineNo < initLine; ++lineNo) {
                String string = bufferedReader.readLine();
            }
            while ((dataEachLine = bufferedReader.readLine()) != null && lineNo < endLine) {
                ++lineNo;
                contentList.add(dataEachLine);
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
        return contentList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readAllLines(File file, String charset, int initLine, int endLine, boolean ignoreEmpty) {
        ArgUtil.notNull(file, "file");
        ArgUtil.notEmpty(charset, "charset");
        if (!file.exists()) {
            throw new CommonRuntimeException("File not exists!");
        }
        try (FileInputStream inputStream = new FileInputStream(file);){
            List<String> list = FileUtil.readAllLines(inputStream, charset, initLine, endLine, ignoreEmpty);
            return list;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static List<String> readAllLines(InputStream inputStream, String charset, int initLine, int endLine, boolean ignoreEmpty) {
        ArgUtil.notNull(inputStream, "inputStream");
        ArgUtil.notEmpty(charset, "charset");
        LinkedList<String> contentList = new LinkedList<String>();
        try (InputStreamReader inputStreamReader = new InputStreamReader(inputStream, charset);
             BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
            String dataEachLine;
            int lineNo;
            for (lineNo = 0; lineNo < initLine; ++lineNo) {
                String string = bufferedReader.readLine();
            }
            while ((dataEachLine = bufferedReader.readLine()) != null && lineNo < endLine) {
                ++lineNo;
                if (ignoreEmpty && StringUtil.isEmpty(dataEachLine)) continue;
                contentList.add(dataEachLine);
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return contentList;
    }

    public static List<String> readAllLines(InputStream inputStream, String charset, int initLine, int endLine) {
        return FileUtil.readAllLines(inputStream, charset, initLine, endLine, true);
    }

    public static List<String> readAllLines(InputStream inputStream, String charset, int initLine) {
        return FileUtil.readAllLines(inputStream, charset, initLine, Integer.MAX_VALUE);
    }

    public static List<String> readAllLines(InputStream inputStream, String charset) {
        return FileUtil.readAllLines(inputStream, charset, 0);
    }

    public static List<String> readAllLines(InputStream inputStream) {
        return FileUtil.readAllLines(inputStream, "UTF-8");
    }

    public static List<String> readAllLines(String filePath, String charset, boolean ignoreEmpty) {
        File file = new File(filePath);
        return FileUtil.readAllLines(file, charset, 0, Integer.MAX_VALUE, ignoreEmpty);
    }

    public static List<String> readAllLines(File file, String charset, boolean ignoreEmpty) {
        return FileUtil.readAllLines(file, charset, 0, Integer.MAX_VALUE, ignoreEmpty);
    }

    public static List<String> readAllLines(File file, String charset) {
        return FileUtil.readAllLines(file, charset, false);
    }

    public static List<String> readAllLines(File file) {
        return FileUtil.readAllLines(file, "UTF-8");
    }

    public static List<String> readAllLines(String filePath, String charset) {
        return FileUtil.readAllLines(filePath, charset, false);
    }

    public static List<String> readAllLines(String filePath) {
        return FileUtil.readAllLines(filePath, "UTF-8");
    }

    public static void copyDir(String sourceDir, String targetDir) throws IOException {
        File file = new File(sourceDir);
        Object[] filePath = file.list();
        if (!new File(targetDir).exists()) {
            new File(targetDir).mkdir();
        }
        if (ArrayUtil.isNotEmpty(filePath)) {
            for (Object aFilePath : filePath) {
                if (new File(sourceDir + File.separator + (String)aFilePath).isDirectory()) {
                    FileUtil.copyDir(sourceDir + File.separator + (String)aFilePath, targetDir + File.separator + (String)aFilePath);
                }
                if (!new File(sourceDir + File.separator + (String)aFilePath).isFile()) continue;
                FileUtil.copyFile(sourceDir + File.separator + (String)aFilePath, targetDir + File.separator + (String)aFilePath);
            }
        }
    }

    public static void copyFile(String sourceFile, String targetPath) throws IOException {
        File oldFile = new File(sourceFile);
        File file = new File(targetPath);
        try (FileInputStream in = new FileInputStream(oldFile);
             FileOutputStream out = new FileOutputStream(file);){
            byte[] buffer = new byte[0x200000];
            while (in.read(buffer) != -1) {
                out.write(buffer);
            }
        }
    }

    public static void write(String filePath, CharSequence line, OpenOption ... openOptions) {
        FileUtil.write(filePath, Collections.singletonList(line), openOptions);
    }

    public static void write(String filePath, Iterable<? extends CharSequence> lines, OpenOption ... openOptions) {
        FileUtil.write(filePath, lines, "UTF-8", openOptions);
    }

    public static void write(String filePath, Iterable<? extends CharSequence> lines, String charset, OpenOption ... openOptions) {
        try {
            File parent;
            ArgUtil.notNull(lines, "charSequences");
            CharsetEncoder encoder = Charset.forName(charset).newEncoder();
            Path path = Paths.get(filePath, new String[0]);
            Path pathParent = path.getParent();
            if (pathParent != null && !(parent = pathParent.toFile()).exists()) {
                parent.mkdirs();
            }
            OutputStream out = path.getFileSystem().provider().newOutputStream(path, openOptions);
            try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, encoder));){
                for (CharSequence charSequence : lines) {
                    writer.append(charSequence);
                    writer.newLine();
                }
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static boolean createFile(String filePath) {
        boolean mkdirResult;
        if (StringUtil.isEmpty(filePath)) {
            return false;
        }
        if (FileUtil.exists(filePath, new LinkOption[0])) {
            return true;
        }
        File file = new File(filePath);
        File dir = file.getParentFile();
        if (dir != null && FileUtil.notExists(dir) && !(mkdirResult = dir.mkdirs())) {
            return false;
        }
        try {
            return file.createNewFile();
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static boolean exists(String filePath, LinkOption ... options) {
        if (StringUtil.isEmpty(filePath)) {
            return false;
        }
        Path path = Paths.get(filePath, new String[0]);
        return Files.exists(path, options);
    }

    public static boolean notExists(String filePath, LinkOption ... options) {
        return !FileUtil.exists(filePath, options);
    }

    public static boolean notExists(File file) {
        ArgUtil.notNull(file, "file");
        return !file.exists();
    }

    public static boolean isEmpty(String filePath) {
        if (StringUtil.isEmpty(filePath)) {
            return true;
        }
        File file = new File(filePath);
        return file.length() <= 0L;
    }

    public static boolean isNotEmpty(String filePath) {
        return !FileUtil.isEmpty(filePath);
    }

    /*
     * Exception decompiling
     */
    public static byte[] getFileBytes(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static byte[] getFileBytes(String filePath) {
        ArgUtil.notNull(filePath, "filePath");
        File file = new File(filePath);
        return FileUtil.getFileBytes(file);
    }

    public static void createFile(String filePath, byte[] bytes) {
        File file = FileUtil.createFileAssertSuccess(filePath);
        try (FileOutputStream fos = new FileOutputStream(file);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            bos.write(bytes);
        }
        catch (Exception e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static File createFileAssertSuccess(String filePath) {
        boolean mkdirResult;
        ArgUtil.notEmpty(filePath, "filePath");
        File file = new File(filePath);
        if (file.exists()) {
            return file;
        }
        File dir = file.getParentFile();
        if (FileUtil.notExists(dir) && !(mkdirResult = dir.mkdirs())) {
            throw new CommonRuntimeException("Parent file create fail " + filePath);
        }
        try {
            boolean createFile = file.createNewFile();
            if (!createFile) {
                throw new CommonRuntimeException("Create new file fail for path " + filePath);
            }
            return file;
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static void deleteFile(File file) {
        boolean result;
        ArgUtil.notNull(file, "file");
        if (file.exists() && !(result = file.delete())) {
            throw new CommonRuntimeException("Delete file fail for path " + file.getAbsolutePath());
        }
    }

    public static void deleteFile(String filePath) {
        ArgUtil.notEmpty(filePath, "filePath");
        File file = new File(filePath);
        FileUtil.deleteFile(file);
    }

    public static File createTempFile(String name, String suffix) {
        try {
            ArgUtil.notEmpty(name, "prefix");
            ArgUtil.notEmpty(suffix, "suffix");
            return File.createTempFile(name, suffix);
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static File createTempFile(String nameWithSuffix) {
        try {
            ArgUtil.notEmpty(nameWithSuffix, "fileName");
            String[] strings = nameWithSuffix.split("\\.");
            return File.createTempFile(strings[0], strings[1]);
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static boolean isImage(String string) {
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        return string.endsWith(".png") || string.endsWith(".jpeg") || string.endsWith(".jpg") || string.endsWith(".gif");
    }

    public static <K, V> Map<K, V> readToMap(InputStream inputStream, String charset, IMapHandler<K, V, String> mapHandler) {
        List<String> allLines = FileUtil.readAllLines(inputStream, charset);
        return MapUtil.toMap(allLines, mapHandler);
    }

    public static <K, V> Map<K, V> readToMap(String path, String charset, IMapHandler<K, V, String> mapHandler) {
        List<String> allLines = FileUtil.readAllLines(path, charset);
        return MapUtil.toMap(allLines, mapHandler);
    }

    public static <K, V> Map<K, V> readToMap(String path, IMapHandler<K, V, String> mapHandler) {
        return FileUtil.readToMap(path, "UTF-8", mapHandler);
    }

    public static Map<String, String> readToMap(String path) {
        return FileUtil.readToMap(path, " ");
    }

    public static Map<String, String> readToMap(String path, final String splitter) {
        return FileUtil.readToMap(path, new IMapHandler<String, String, String>(){

            @Override
            public String getKey(String o) {
                return o.split(splitter)[0];
            }

            @Override
            public String getValue(String o) {
                return o.split(splitter)[1];
            }
        });
    }

    public static String getFileName(String path) {
        if (StringUtil.isEmptyTrim(path)) {
            return "";
        }
        File file = new File(path);
        String name = file.getName();
        return name.substring(0, name.lastIndexOf(46));
    }

    public static String getDirPath(String path) {
        Path path1 = Paths.get(path, new String[0]);
        return path1.getParent().toAbsolutePath().toString() + File.separator;
    }

    public static String trimWindowsSpecialChars(String name) {
        if (StringUtil.isEmpty(name)) {
            return name;
        }
        return name.replaceAll("[?/\\\\*<>|:\"]", "");
    }

    public static boolean rename(String sourcePath, String targetPath) {
        File sourceFile = new File(sourcePath);
        File targetFile = new File(targetPath);
        return sourceFile.renameTo(targetFile);
    }

    public static void merge(String result, String ... sources) {
        ArgUtil.notEmpty(result, "result");
        ArgUtil.notEmpty(sources, "sources");
        try (FileOutputStream os = new FileOutputStream(result);){
            for (String source : sources) {
                byte[] bytes = FileUtil.getFileBytes(source);
                ((OutputStream)os).write(bytes);
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static void merge(String result, byte[] ... byteArrays) {
        ArgUtil.notEmpty(result, "result");
        ArgUtil.notEmpty((Object[])byteArrays, "byteArrays");
        try (FileOutputStream os = new FileOutputStream(result);){
            for (byte[] bytes : byteArrays) {
                ((OutputStream)os).write(bytes);
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static void merge(String result, List<byte[]> byteArrayList) {
        ArgUtil.notEmpty(result, "result");
        ArgUtil.notEmpty(byteArrayList, "byteArrayList");
        try (FileOutputStream os = new FileOutputStream(result);){
            for (byte[] bytes : byteArrayList) {
                ((OutputStream)os).write(bytes);
            }
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static void write(String filePath, byte[] bytes) {
        ArgUtil.notEmpty(filePath, "filePath");
        try (FileOutputStream os = new FileOutputStream(filePath);){
            ((OutputStream)os).write(bytes);
        }
        catch (IOException e) {
            throw new CommonRuntimeException(e);
        }
    }

    public static String escapeWindowsSpecial(String fileName) {
        if (StringUtil.isEmpty(fileName)) {
            return fileName;
        }
        return fileName.replaceAll("[\"<>/\\\\|:*?]", "");
    }

    public static boolean createDir(String dir) {
        if (StringUtil.isEmpty(dir)) {
            return false;
        }
        File file = new File(dir);
        if (file.isDirectory()) {
            return file.mkdirs();
        }
        return false;
    }

    public static void truncate(String filePath) {
        FileUtil.write(filePath, "", StandardOpenOption.TRUNCATE_EXISTING);
    }

    public static void append(String filePath, String line) {
        FileUtil.write(filePath, line, StandardOpenOption.APPEND);
    }

    public static void append(String filePath, Collection<String> collection) {
        FileUtil.write(filePath, collection, StandardOpenOption.APPEND);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String fileToBase64(String filePath) {
        File file = new File(filePath);
        try (FileInputStream inputFile = new FileInputStream(file);){
            byte[] buffer = new byte[(int)file.length()];
            inputFile.read(buffer);
            String plainText = new BASE64Encoder().encode(buffer);
            String string = plainText.replaceAll("\r", "").replaceAll("\n", "");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void base64ToFile(String base64Code, String targetPath) {
        FileUtil.createFile(targetPath);
        if (base64Code.contains(",")) {
            base64Code = base64Code.split(",")[1];
        }
        try (FileOutputStream out = new FileOutputStream(targetPath);){
            byte[] buffer = new BASE64Decoder().decodeBuffer(base64Code);
            out.write(buffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedReader getBufferedReader(String sourceFilePath) {
        try {
            ArgUtil.notEmpty(sourceFilePath, "sourceFilePath");
            Path path = Paths.get(sourceFilePath, new String[0]);
            InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
            InputStreamReader streamReader = new InputStreamReader(inputStream);
            return new BufferedReader(streamReader);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeBufferReader(BufferedReader bufferedReader) {
        if (bufferedReader != null) {
            try {
                bufferedReader.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static BufferedWriter getBufferedWriter(String filePath) {
        try {
            ArgUtil.notEmpty(filePath, "filePath");
            return new BufferedWriter(new FileWriter(filePath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void closeBufferedWriter(BufferedWriter bufferedWriter) {
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void sortedUnique(String sourceFile, String targetFile) {
        String prefixLine = null;
        try (BufferedReader sourceReader = FileUtil.getBufferedReader(sourceFile);
             BufferedWriter resultWriter = FileUtil.getBufferedWriter(targetFile);){
            String sourceLine = sourceReader.readLine();
            while (sourceLine != null) {
                if (!sourceLine.equals(prefixLine)) {
                    resultWriter.write(sourceLine);
                    resultWriter.newLine();
                }
                prefixLine = sourceLine;
                sourceLine = sourceReader.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isMdFile(String filePath) {
        if (StringUtil.isEmpty(filePath)) {
            return false;
        }
        return filePath.endsWith(".md") || filePath.endsWith(".markdown");
    }

    public static List<Path> getMdFilePathList(Path dirPath, boolean subTree) {
        try {
            if (subTree) {
                MarkdownFileWalker markdownFileWalker = new MarkdownFileWalker();
                Files.walkFileTree(dirPath, markdownFileWalker);
                return markdownFileWalker.getPathList();
            }
            File dir = dirPath.toFile();
            Object[] files = dir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return FileUtil.isMdFile(name);
                }
            });
            if (ArrayUtil.isNotEmpty(files)) {
                ArrayList<Path> paths = new ArrayList<Path>();
                for (Object file : files) {
                    paths.add(((File)file).toPath());
                }
                return paths;
            }
            return Collections.emptyList();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

