/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.instance.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.annotation.ThreadSafe;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.response.exception.CommonRuntimeException;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.instance.Instance;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.ObjectUtil;

@ThreadSafe
public final class InstanceFactory
implements Instance {
    private final Map<String, Object> singletonMap = new ConcurrentHashMap<String, Object>();
    private ThreadLocal<Map<String, Object>> mapThreadLocal = new ThreadLocal();

    private InstanceFactory() {
    }

    public static InstanceFactory getInstance() {
        return SingletonHolder.INSTANCE_FACTORY;
    }

    public static <T> T singletion(Class<T> tClass) {
        return InstanceFactory.getInstance().singleton(tClass);
    }

    public static <T> T singletion(Class<T> tClass, String groupName) {
        return InstanceFactory.getInstance().singleton(tClass, groupName);
    }

    @Override
    public <T> T singleton(Class<T> tClass, String groupName) {
        return this.getSingleton(tClass, groupName, this.singletonMap);
    }

    @Override
    public <T> T singleton(Class<T> tClass) {
        this.notNull(tClass);
        return this.getSingleton(tClass, this.singletonMap);
    }

    @Override
    public <T> T threadLocal(Class<T> tClass) {
        this.notNull(tClass);
        Map<String, Object> map = this.mapThreadLocal.get();
        if (ObjectUtil.isNull(map)) {
            map = new ConcurrentHashMap<String, Object>();
        }
        T instance = this.getSingleton(tClass, map);
        this.mapThreadLocal.set(map);
        return instance;
    }

    @Override
    public <T> T multiple(Class<T> tClass) {
        this.notNull(tClass);
        try {
            return tClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new CommonRuntimeException(e);
        }
    }

    @Override
    public <T> T threadSafe(Class<T> tClass) {
        if (tClass.isAnnotationPresent(ThreadSafe.class)) {
            return this.singleton(tClass);
        }
        return this.multiple(tClass);
    }

    private <T> T getSingleton(Class<T> tClass, Map<String, Object> instanceMap) {
        this.notNull(tClass);
        String fullClassName = tClass.getName();
        Object instance = instanceMap.get(fullClassName);
        if (ObjectUtil.isNull(instance)) {
            instance = this.multiple(tClass);
            instanceMap.put(fullClassName, instance);
        }
        return (T)instance;
    }

    private <T> T getSingleton(Class<T> tClass, String group, Map<String, Object> instanceMap) {
        this.notNull(tClass);
        ArgUtil.notEmpty(group, "key");
        String fullClassName = tClass.getName() + "-" + group;
        Object instance = instanceMap.get(fullClassName);
        if (ObjectUtil.isNull(instance)) {
            instance = this.multiple(tClass);
            instanceMap.put(fullClassName, instance);
        }
        return (T)instance;
    }

    private void notNull(Class tClass) {
        ArgUtil.notNull(tClass, "class");
    }

    private static class SingletonHolder {
        private static final InstanceFactory INSTANCE_FACTORY = new InstanceFactory();

        private SingletonHolder() {
        }
    }
}

