/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.cache.impl;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.cache.ICache;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.guava.Guavas;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.reflect.PropertyDescriptorUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.CollectionUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.MapUtil;

public class PropertyDescriptorListCache
implements ICache<Class, List<PropertyDescriptor>> {
    private static final PropertyDescriptorListCache INSTANCE = new PropertyDescriptorListCache();
    private static final Map<Class, List<PropertyDescriptor>> MAP = new ConcurrentHashMap<Class, List<PropertyDescriptor>>();
    private static final Map<Class, Map<String, Method>> READ_METHOD_MAP = new ConcurrentHashMap<Class, Map<String, Method>>();

    public static PropertyDescriptorListCache getInstance() {
        return INSTANCE;
    }

    @Override
    public List<PropertyDescriptor> get(Class key) {
        List<PropertyDescriptor> fieldList = MAP.get(key);
        if (CollectionUtil.isNotEmpty(fieldList)) {
            return fieldList;
        }
        fieldList = PropertyDescriptorUtil.getAllPropertyDescriptorList(key);
        this.set(key, fieldList);
        return fieldList;
    }

    @Override
    public void set(Class key, List<PropertyDescriptor> value) {
        MAP.put(key, value);
    }

    public Map<String, Method> getReadMethodMap(Class beanClass) {
        Map<String, Method> readMethodMap = READ_METHOD_MAP.get(beanClass);
        if (MapUtil.isNotEmpty(readMethodMap)) {
            return readMethodMap;
        }
        List<PropertyDescriptor> propertyDescriptors = PropertyDescriptorListCache.getInstance().get(beanClass);
        readMethodMap = Guavas.newHashMap(propertyDescriptors.size());
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            readMethodMap.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod());
        }
        READ_METHOD_MAP.put(beanClass, readMethodMap);
        return readMethodMap;
    }
}

