/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.reflect.meta.field.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.reflect.meta.field.IFieldMeta;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.reflect.meta.field.impl.FieldMeta;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.condition.ICondition;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.support.handler.IHandler;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.ObjectUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.StringUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.reflect.ClassUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.reflect.ReflectFieldUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.reflect.ReflectMethodUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.ArrayUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.CollectionUtil;

public final class FieldMetas {
    private FieldMetas() {
    }

    public static List<IFieldMeta> buildFieldsMetaList(Class clazz, Object instance) {
        ArgUtil.notNull(clazz, "clazz");
        List<Field> fieldList = ClassUtil.getModifyableFieldList(clazz);
        return FieldMetas.buildFieldsMetaList(fieldList, instance);
    }

    public static List<IFieldMeta> buildFieldsMetaList(Class clazz) {
        return FieldMetas.buildFieldsMetaList(clazz, null);
    }

    private static List<IFieldMeta> buildFieldsMetaList(List<Field> fieldList, final Object instance) {
        return CollectionUtil.toList(fieldList, new IHandler<Field, IFieldMeta>(){

            @Override
            public IFieldMeta handle(Field field) {
                FieldMeta fieldMeta = new FieldMeta();
                fieldMeta.setName(field.getName());
                fieldMeta.setType(field.getType());
                fieldMeta.setField(field);
                fieldMeta.setComponentType(ReflectFieldUtil.getComponentType(field));
                if (ObjectUtil.isNotNull(instance)) {
                    fieldMeta.setValue(ReflectFieldUtil.getValue(field, instance));
                }
                return fieldMeta;
            }
        });
    }

    public static List<IFieldMeta> buildReadMethodsMetaList(Class clazz) {
        return FieldMetas.buildReadMethodsMetaList(clazz, null);
    }

    public static List<IFieldMeta> buildReadMethodsMetaList(Class clazz, Object instance) {
        ArgUtil.notNull(clazz, "clazz");
        List<Method> methodList = ClassUtil.getMethodList(clazz);
        return FieldMetas.buildMethodsMetaList(methodList, instance, new ICondition<Method>(){

            @Override
            public boolean condition(Method method) {
                String methodName = method.getName();
                Class<?> returnType = method.getReturnType();
                Object[] paramTypes = method.getParameterTypes();
                if (ArrayUtil.isNotEmpty(paramTypes)) {
                    return false;
                }
                if (Boolean.TYPE == returnType) {
                    return methodName.startsWith("is");
                }
                return methodName.startsWith("get") && !methodName.equals("getClass");
            }
        });
    }

    public static List<IFieldMeta> buildWriteMethodsMetaList(Class clazz) {
        return FieldMetas.buildWriteMethodsMetaList(clazz, null);
    }

    public static List<IFieldMeta> buildWriteMethodsMetaList(Class clazz, Object instance) {
        ArgUtil.notNull(clazz, "clazz");
        List<Method> methodList = ClassUtil.getMethodList(clazz);
        return FieldMetas.buildMethodsMetaList(methodList, instance, new ICondition<Method>(){

            @Override
            public boolean condition(Method method) {
                Class<?>[] paramTypes = method.getParameterTypes();
                String methodName = method.getName();
                return methodName.startsWith("set") && paramTypes.length == 1;
            }
        });
    }

    private static List<IFieldMeta> buildMethodsMetaList(List<Method> methodList, final Object instance, ICondition<Method> methodCondition) {
        List<Method> getMethodList = CollectionUtil.conditionList(methodList, methodCondition);
        return CollectionUtil.toList(getMethodList, new IHandler<Method, IFieldMeta>(){

            @Override
            public IFieldMeta handle(Method method) {
                String methodName = method.getName();
                String fieldName = methodName.startsWith("is") ? StringUtil.firstToLowerCase(methodName.substring(2)) : StringUtil.firstToLowerCase(methodName.substring(3));
                FieldMeta fieldMeta = new FieldMeta();
                fieldMeta.setName(fieldName);
                if (methodName.startsWith("is") || methodName.startsWith("get")) {
                    fieldMeta.setType(method.getReturnType());
                    fieldMeta.setComponentType(ReflectMethodUtil.getGenericReturnParamType(method, 0));
                } else {
                    fieldMeta.setType(method.getParameterTypes()[0]);
                    Class componentType = ReflectMethodUtil.getParamGenericType(method, 0, 0);
                    fieldMeta.setComponentType(componentType);
                }
                if (ObjectUtil.isNotNull(instance)) {
                    Object value = ReflectMethodUtil.invoke(instance, method, new Object[0]);
                    fieldMeta.setValue(value);
                }
                return fieldMeta;
            }
        });
    }
}

