/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.reflect.meta.annotation.impl;

import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.reflect.meta.annotation.IAnnotationTypeMeta;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.common.ArgUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.guava.Guavas;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.ObjectUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.lang.reflect.ReflectAnnotationUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.ArrayUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.CollectionUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.MapUtil;
import net.guizhanss.minecraft.guizhanlib.libs.houbb.heaven.util.util.Optional;

public abstract class AbstractAnnotationTypeMeta
implements IAnnotationTypeMeta {
    private Map<String, Annotation> annotationRefMap = new ConcurrentHashMap<String, Annotation>();

    protected abstract Annotation[] getAnnotations();

    protected AbstractAnnotationTypeMeta() {
    }

    @Override
    public boolean isAnnotated(String annotationName) {
        Annotation annotation = this.getAnnotation(annotationName);
        return ObjectUtil.isNotNull(annotation);
    }

    @Override
    public Annotation getAnnotation(String annotationName) {
        ArgUtil.notEmpty(annotationName, "annotationName");
        Optional<Annotation> annotationOptional = this.getAnnotationOpt(this.getAnnotations(), annotationName);
        return annotationOptional.orDefault(null);
    }

    @Override
    public boolean isAnnotatedOrRef(String annotationName) {
        if (this.isAnnotated(annotationName)) {
            return true;
        }
        List<Annotation> annotationRefs = this.getAnnotationRefs(annotationName);
        return CollectionUtil.isNotEmpty(annotationRefs);
    }

    @Override
    public boolean isAnnotatedOrRef(List<Class> classList) {
        if (CollectionUtil.isEmpty(classList)) {
            return false;
        }
        for (Class clazz : classList) {
            if (!this.isAnnotatedOrRef(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isAnnotationRef(Class clazz) {
        return this.isAnnotatedOrRef(clazz.getName()) && !this.isAnnotated(clazz.getName());
    }

    @Override
    public List<Annotation> getAnnotationOrRefs(String annotationName) {
        Set<Annotation> annotationSet = Guavas.newHashSet();
        Annotation annotation = this.getAnnotation(annotationName);
        if (ObjectUtil.isNotNull(annotation)) {
            annotationSet.add(annotation);
        }
        List<Annotation> annotationRefList = this.getAnnotationRefs(annotationName);
        annotationSet.addAll(annotationRefList);
        return Guavas.newArrayList(annotationSet);
    }

    private Optional<Annotation> getAnnotationOpt(Annotation[] annotations, String annotationName) {
        List<Annotation> annotationList = ArrayUtil.toList(annotations);
        return this.getAnnotationOpt(annotationList, annotationName);
    }

    private Optional<Annotation> getAnnotationOpt(List<Annotation> annotations, String annotationName) {
        if (CollectionUtil.isEmpty(annotations)) {
            return Optional.empty();
        }
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getName().equals(annotationName)) continue;
            return Optional.ofNullable(annotation);
        }
        return Optional.empty();
    }

    @Override
    public List<Annotation> getAnnotationRefs(String annotationName) {
        Set<Annotation> annotationSet = Guavas.newHashSet();
        if (ArrayUtil.isNotEmpty(this.getAnnotations())) {
            for (Annotation annotation : this.getAnnotations()) {
                Annotation[] annotationRefs = annotation.annotationType().getAnnotations();
                Optional<Annotation> annotationRefOptional = this.getAnnotationOpt(annotationRefs, annotationName);
                if (!annotationRefOptional.isPresent()) continue;
                String key = annotationName + annotation.annotationType().getName();
                this.annotationRefMap.put(key, annotationRefOptional.get());
                annotationSet.add(annotation);
            }
        }
        return Guavas.newArrayList(annotationSet);
    }

    @Override
    public Annotation getAnnotationReferenced(String annotationName, String annotationRefName) {
        ArgUtil.notEmpty(annotationName, "annotationName");
        ArgUtil.notEmpty(annotationRefName, "annotationRefName");
        String key = annotationName + annotationRefName;
        return this.annotationRefMap.get(key);
    }

    @Override
    public Map<String, Object> getAnnotationAttributes(String annotationName) {
        ArgUtil.notEmpty(annotationName, "annotationName");
        Annotation annotation = this.getAnnotation(annotationName);
        if (ObjectUtil.isNull(annotation)) {
            return null;
        }
        return ReflectAnnotationUtil.getAnnotationAttributes(annotation);
    }

    @Override
    public Map<String, Object> getAnnotationOrRefAttributes(String annotationName) {
        ArgUtil.notEmpty(annotationName, "annotationName");
        List<Annotation> annotationList = this.getAnnotationOrRefs(annotationName);
        if (CollectionUtil.isEmpty(annotationList)) {
            return null;
        }
        Annotation annotation = annotationList.get(0);
        return ReflectAnnotationUtil.getAnnotationAttributes(annotation);
    }

    @Override
    public Object getAnnotationOrRefAttribute(String annotationName, String attrMethodName) {
        ArgUtil.notEmpty(annotationName, "annotationName");
        ArgUtil.notEmpty(attrMethodName, "attrMethodName");
        Map<String, Object> attrMap = this.getAnnotationOrRefAttributes(annotationName);
        if (MapUtil.isEmpty(attrMap)) {
            return null;
        }
        return attrMap.get(attrMethodName);
    }

    @Override
    public Object getAnnotationAttr(Annotation annotation, String methodName) {
        ArgUtil.notNull(annotation, "annotation");
        ArgUtil.notEmpty(methodName, "methodName");
        Map<String, Object> attrs = ReflectAnnotationUtil.getAnnotationAttributes(annotation);
        return attrs.get(methodName);
    }

    @Override
    public Object getAnnotatedAttr(Class<? extends Annotation> clazz, String methodName) {
        ArgUtil.notNull(clazz, "clazz");
        ArgUtil.notEmpty(methodName, "methodName");
        Annotation annotation = this.getAnnotation(clazz.getName());
        if (ObjectUtil.isNotNull(annotation)) {
            return this.getAnnotationAttr(annotation, methodName);
        }
        return null;
    }

    @Override
    public Object getAnnotationReferencedAttr(Class<? extends Annotation> clazz, String methodName) {
        ArgUtil.notNull(clazz, "clazz");
        ArgUtil.notEmpty(methodName, "methodName");
        String annotationName = clazz.getName();
        if (ArrayUtil.isNotEmpty(this.getAnnotations())) {
            for (Annotation annotation : this.getAnnotations()) {
                Object[] annotationRefs = annotation.annotationType().getAnnotations();
                if (!ArrayUtil.isNotEmpty(annotationRefs)) continue;
                for (Object annotationRef : annotationRefs) {
                    if (!annotationName.equals(annotationRef.annotationType().getName())) continue;
                    return this.getAnnotationAttr((Annotation)annotationRef, methodName);
                }
            }
        }
        return null;
    }
}

