/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.entity;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import net.guizhanss.minecraft.guizhanlib.gugu.localization.MinecraftLocalization;
import org.bukkit.entity.Villager;

public final class VillagerHelper {
    private static final Map<Villager.Type, String> TYPE_MAP = Map.of(Villager.Type.PLAINS, "\u5e73\u539f", Villager.Type.DESERT, "\u6c99\u6f20", Villager.Type.JUNGLE, "\u4e1b\u6797", Villager.Type.SAVANNA, "\u70ed\u5e26\u8349\u539f", Villager.Type.SNOW, "\u96ea\u5730", Villager.Type.SWAMP, "\u6cbc\u6cfd", Villager.Type.TAIGA, "\u9488\u53f6\u6797");

    @Nonnull
    public static String getProfessionKey(@Nonnull Villager.Profession profession) {
        Preconditions.checkNotNull((Object)profession);
        return profession.translationKey();
    }

    @Nonnull
    public static String getProfessionName(@Nonnull Villager.Profession profession) {
        Preconditions.checkNotNull((Object)profession);
        return MinecraftLocalization.getOrDefault(VillagerHelper.getProfessionKey(profession), StringUtil.humanize(profession.name()));
    }

    @Nonnull
    public static String getTypeName(@Nonnull Villager.Type type) {
        Preconditions.checkNotNull((Object)type);
        return TYPE_MAP.getOrDefault(type, "\u672a\u77e5");
    }

    @Generated
    private VillagerHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

