/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.entity;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import org.bukkit.entity.Rabbit;

public final class RabbitHelper {
    private static final Map<Rabbit.Type, String> TYPE_MAP = Map.of(Rabbit.Type.BLACK, "\u9ed1\u8272", Rabbit.Type.BLACK_AND_WHITE, "\u9ed1\u767d\u76f8\u95f4", Rabbit.Type.BROWN, "\u8910\u8272", Rabbit.Type.GOLD, "\u91d1\u8272", Rabbit.Type.SALT_AND_PEPPER, "\u80e1\u6912\u76d0\u8272", Rabbit.Type.THE_KILLER_BUNNY, "\u6740\u624b\u5154", Rabbit.Type.WHITE, "\u767d\u8272");

    @Nonnull
    public static String getTypeName(@Nonnull Rabbit.Type type) {
        Preconditions.checkNotNull((Object)type);
        return TYPE_MAP.getOrDefault(type, "\u672a\u77e5");
    }

    @Nonnull
    public static String getTypeName(@Nonnull String type) {
        Preconditions.checkNotNull((Object)type);
        try {
            Rabbit.Type inst = Rabbit.Type.valueOf((String)StringUtil.dehumanize(type));
            return RabbitHelper.getTypeName(inst);
        }
        catch (Exception ex) {
            return StringUtil.humanize(type);
        }
    }

    @Generated
    private RabbitHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

