/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.entity;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import org.bukkit.entity.Panda;

public final class PandaHelper {
    private static final Map<Panda.Gene, String> VARIANT_MAP = Map.of(Panda.Gene.AGGRESSIVE, "\u597d\u6597", Panda.Gene.BROWN, "\u68d5\u8272", Panda.Gene.LAZY, "\u61d2\u60f0", Panda.Gene.NORMAL, "\u666e\u901a", Panda.Gene.PLAYFUL, "\u987d\u76ae", Panda.Gene.WEAK, "\u865a\u5f31", Panda.Gene.WORRIED, "\u53d1\u6101");

    @Nonnull
    public static String getGeneName(@Nonnull Panda.Gene variant) {
        Preconditions.checkNotNull((Object)variant);
        return VARIANT_MAP.getOrDefault(variant, "\u672a\u77e5");
    }

    @Nonnull
    public static String getGeneName(@Nonnull String variant) {
        Preconditions.checkNotNull((Object)variant);
        try {
            Panda.Gene inst = Panda.Gene.valueOf((String)StringUtil.dehumanize(variant));
            return PandaHelper.getGeneName(inst);
        }
        catch (Exception ex) {
            return StringUtil.humanize(variant);
        }
    }

    @Generated
    private PandaHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

