/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.entity;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import org.bukkit.entity.Horse;

public final class HorseHelper {
    private static final Map<Horse.Color, String> COLOR_MAP = Map.of(Horse.Color.BLACK, "\u9ed1\u8272", Horse.Color.BROWN, "\u8910\u8272", Horse.Color.CHESTNUT, "\u6817\u8272", Horse.Color.CREAMY, "\u5976\u6cb9\u8272", Horse.Color.DARK_BROWN, "\u6df1\u8910\u8272", Horse.Color.GRAY, "\u7070\u8272", Horse.Color.WHITE, "\u767d\u8272");
    private static final Map<Horse.Style, String> STYLE_MAP = Map.of(Horse.Style.BLACK_DOTS, "\u9ed1\u8272\u6591\u70b9", Horse.Style.NONE, "\u65e0", Horse.Style.WHITE, "\u767d\u8272", Horse.Style.WHITE_DOTS, "\u767d\u8272\u6591\u70b9", Horse.Style.WHITEFIELD, "\u767d\u8272\u6761\u7eb9");

    @Nonnull
    public static String getColorName(@Nonnull Horse.Color color) {
        Preconditions.checkNotNull((Object)color);
        return COLOR_MAP.getOrDefault(color, "\u672a\u77e5");
    }

    @Nonnull
    public static String getColorName(@Nonnull String variant) {
        Preconditions.checkNotNull((Object)variant);
        try {
            Horse.Color inst = Horse.Color.valueOf((String)StringUtil.dehumanize(variant));
            return HorseHelper.getColorName(inst);
        }
        catch (Exception ex) {
            return StringUtil.humanize(variant);
        }
    }

    @Nonnull
    public static String getStyleName(@Nonnull Horse.Style style) {
        Preconditions.checkNotNull((Object)style);
        return STYLE_MAP.getOrDefault(style, "\u672a\u77e5");
    }

    @Nonnull
    public static String getStyleName(@Nonnull String variant) {
        Preconditions.checkNotNull((Object)variant);
        try {
            Horse.Style inst = Horse.Style.valueOf((String)StringUtil.dehumanize(variant));
            return HorseHelper.getStyleName(inst);
        }
        catch (Exception ex) {
            return StringUtil.humanize(variant);
        }
    }

    @Generated
    private HorseHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

