/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.entity;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import org.bukkit.entity.Frog;

public final class FrogHelper {
    private static final Map<Frog.Variant, String> VARIANT_MAP = Map.of(Frog.Variant.TEMPERATE, "\u6a59\u8272", Frog.Variant.COLD, "\u7eff\u8272", Frog.Variant.WARM, "\u767d\u8272");

    @Nonnull
    public static String getVariantName(@Nonnull Frog.Variant variant) {
        Preconditions.checkNotNull((Object)variant);
        return VARIANT_MAP.getOrDefault(variant, "\u672a\u77e5");
    }

    @Nonnull
    public static String getVariantName(@Nonnull String variant) {
        Preconditions.checkNotNull((Object)variant);
        try {
            Frog.Variant inst = Frog.Variant.valueOf((String)StringUtil.dehumanize(variant));
            return FrogHelper.getVariantName(inst);
        }
        catch (Exception ex) {
            return StringUtil.humanize(variant);
        }
    }

    @Generated
    private FrogHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

