/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.entity;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import org.bukkit.entity.Fox;

public final class FoxHelper {
    private static final Map<Fox.Type, String> TYPE_MAP = Map.of(Fox.Type.RED, "\u7ea2\u72d0", Fox.Type.SNOW, "\u96ea\u72d0");

    @Nonnull
    public static String getTypeName(@Nonnull Fox.Type type) {
        Preconditions.checkNotNull((Object)type);
        return TYPE_MAP.getOrDefault(type, "\u672a\u77e5");
    }

    @Nonnull
    public static String getTypeName(@Nonnull String type) {
        Preconditions.checkNotNull((Object)type);
        try {
            Fox.Type inst = Fox.Type.valueOf((String)StringUtil.dehumanize(type));
            return FoxHelper.getTypeName(inst);
        }
        catch (Exception ex) {
            return StringUtil.humanize(type);
        }
    }

    @Generated
    private FoxHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

