/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.entity;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import net.guizhanss.minecraft.guizhanlib.gugu.localization.MinecraftLocalization;
import org.bukkit.entity.EntityType;

public final class EntityTypeHelper {
    @Nonnull
    public static String getKey(@Nonnull EntityType instance) {
        Preconditions.checkNotNull((Object)instance);
        return instance.translationKey();
    }

    @Nonnull
    public static String getName(@Nonnull EntityType instance) {
        Preconditions.checkNotNull((Object)instance);
        return MinecraftLocalization.getOrKey(EntityTypeHelper.getKey(instance));
    }

    @Nonnull
    public static String getName(@Nonnull String instance) {
        Preconditions.checkNotNull((Object)instance);
        return EntityTypeHelper.getName(instance, false);
    }

    @Nonnull
    public static String getName(@Nonnull String instance, boolean emptyString) {
        Preconditions.checkNotNull((Object)instance);
        try {
            EntityType type = EntityType.valueOf((String)StringUtil.dehumanize(instance));
            return EntityTypeHelper.getName(type);
        }
        catch (Exception ex) {
            return emptyString ? "" : StringUtil.humanize(instance);
        }
    }

    @Generated
    private EntityTypeHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

