/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.entity;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import org.bukkit.entity.Cat;

public final class CatHelper {
    private static final Map<Cat.Type, String> TYPE_MAP = Map.ofEntries(Map.entry(Cat.Type.ALL_BLACK, "\u9ed1\u732b"), Map.entry(Cat.Type.BLACK, "\u897f\u670d\u732b"), Map.entry(Cat.Type.BRITISH_SHORTHAIR, "\u82f1\u56fd\u77ed\u6bdb\u732b"), Map.entry(Cat.Type.CALICO, "\u82b1\u732b"), Map.entry(Cat.Type.JELLIE, "Jellie"), Map.entry(Cat.Type.PERSIAN, "\u6ce2\u65af\u732b"), Map.entry(Cat.Type.RAGDOLL, "\u5e03\u5076\u732b"), Map.entry(Cat.Type.RED, "\u7ea2\u864e\u6591\u732b"), Map.entry(Cat.Type.SIAMESE, "\u66b9\u7f57\u732b"), Map.entry(Cat.Type.TABBY, "\u864e\u6591\u732b"), Map.entry(Cat.Type.WHITE, "\u767d\u732b"));

    @Nonnull
    public static String getTypeName(@Nonnull Cat.Type type) {
        Preconditions.checkNotNull((Object)type);
        return TYPE_MAP.getOrDefault(type, "\u672a\u77e5");
    }

    @Nonnull
    public static String getTypeName(@Nonnull String type) {
        Preconditions.checkNotNull((Object)type);
        try {
            Cat.Type inst = Cat.Type.valueOf((String)StringUtil.dehumanize(type));
            return CatHelper.getTypeName(inst);
        }
        catch (Exception ex) {
            return StringUtil.humanize(type);
        }
    }

    @Generated
    private CatHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

