/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.entity;

import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import org.bukkit.entity.Axolotl;

public final class AxolotlHelper {
    private static final Map<Axolotl.Variant, String> VARIANT_MAP = Map.of(Axolotl.Variant.LUCY, "\u7c89\u7ea2\u8272", Axolotl.Variant.WILD, "\u68d5\u8272", Axolotl.Variant.GOLD, "\u91d1\u8272", Axolotl.Variant.CYAN, "\u9752\u8272", Axolotl.Variant.BLUE, "\u84dd\u8272");

    @Nonnull
    public static String getVariantName(@Nonnull Axolotl.Variant variant) {
        Preconditions.checkNotNull((Object)variant);
        return VARIANT_MAP.getOrDefault(variant, "\u672a\u77e5");
    }

    @Nonnull
    public static String getVariantName(@Nonnull String variant) {
        Preconditions.checkNotNull((Object)variant);
        try {
            Axolotl.Variant inst = Axolotl.Variant.valueOf((String)StringUtil.dehumanize(variant));
            return AxolotlHelper.getVariantName(inst);
        }
        catch (Exception ex) {
            return StringUtil.humanize(variant);
        }
    }

    @Generated
    private AxolotlHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

