/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.enchantments;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import net.guizhanss.minecraft.guizhanlib.gugu.localization.MinecraftLocalization;
import net.guizhanss.minecraft.guizhanlib.utils.NamespacedKeyUtils;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;

public final class EnchantmentHelper {
    @Nonnull
    public static String getKey(@Nonnull Enchantment instance) {
        Preconditions.checkNotNull((Object)instance);
        return instance.translationKey();
    }

    @Nonnull
    public static String getName(@Nonnull Enchantment instance) {
        Preconditions.checkNotNull((Object)instance);
        return MinecraftLocalization.getOrKey(EnchantmentHelper.getKey(instance));
    }

    @Nonnull
    public static String getName(@Nonnull String instance) {
        Preconditions.checkNotNull((Object)instance);
        return EnchantmentHelper.getName(instance, false);
    }

    @Nonnull
    public static String getName(@Nonnull String instance, boolean emptyString) {
        Preconditions.checkNotNull((Object)instance);
        Enchantment enchantment = (Enchantment)Registry.ENCHANTMENT.get(NamespacedKeyUtils.getMinecraft(instance));
        if (enchantment == null) {
            return emptyString ? "" : StringUtil.humanize(instance);
        }
        return EnchantmentHelper.getName(enchantment);
    }

    @Generated
    private EnchantmentHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

