/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.block;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import net.guizhanss.minecraft.guizhanlib.gugu.localization.MinecraftLocalization;
import org.bukkit.block.Biome;

public final class BiomeHelper {
    @Nonnull
    public static String getKey(@Nonnull Biome instance) {
        Preconditions.checkNotNull((Object)instance);
        return instance.translationKey();
    }

    @Nonnull
    public static String getName(@Nonnull Biome instance) {
        Preconditions.checkNotNull((Object)instance);
        return MinecraftLocalization.getOrKey(BiomeHelper.getKey(instance));
    }

    @Nonnull
    public static String getName(@Nonnull String instance) {
        Preconditions.checkNotNull((Object)instance);
        return BiomeHelper.getName(instance, false);
    }

    @Nonnull
    public static String getName(@Nonnull String instance, boolean emptyString) {
        Preconditions.checkNotNull((Object)instance);
        try {
            Biome biome = Biome.valueOf((String)StringUtil.dehumanize(instance));
            return BiomeHelper.getName(biome);
        }
        catch (Exception ex) {
            return emptyString ? "" : StringUtil.humanize(instance);
        }
    }

    @Generated
    private BiomeHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

