/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers.attribute;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import net.guizhanss.minecraft.guizhanlib.gugu.localization.MinecraftLocalization;
import org.bukkit.attribute.Attribute;

public final class AttributeHelper {
    @Nonnull
    public static String getKey(@Nonnull Attribute instance) {
        Preconditions.checkNotNull((Object)instance);
        return instance.translationKey();
    }

    @Nonnull
    public static String getName(@Nonnull Attribute instance) {
        Preconditions.checkNotNull((Object)instance);
        return MinecraftLocalization.getOrKey(AttributeHelper.getKey(instance));
    }

    @Nonnull
    public static String getName(@Nonnull String instance) {
        Preconditions.checkNotNull((Object)instance);
        return AttributeHelper.getName(instance, false);
    }

    @Nonnull
    public static String getName(@Nonnull String instance, boolean emptyString) {
        Preconditions.checkNotNull((Object)instance);
        try {
            Attribute attribute = Attribute.valueOf((String)StringUtil.dehumanize(instance));
            return AttributeHelper.getName(attribute);
        }
        catch (Exception ex) {
            return emptyString ? "" : StringUtil.humanize(instance);
        }
    }

    @Generated
    private AttributeHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

