/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft.helpers;

import com.google.common.base.Preconditions;
import java.util.Locale;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.common.utils.StringUtil;
import net.guizhanss.minecraft.guizhanlib.gugu.localization.MinecraftLocalization;
import org.bukkit.DyeColor;

public final class DyeColorHelper {
    @Nonnull
    public static String getKey(@Nonnull DyeColor instance) {
        Preconditions.checkNotNull((Object)instance);
        return "color.minecraft." + instance.name().toLowerCase(Locale.ROOT);
    }

    @Nonnull
    public static String getName(@Nonnull DyeColor instance) {
        Preconditions.checkNotNull((Object)instance);
        return MinecraftLocalization.getOrKey(DyeColorHelper.getKey(instance));
    }

    @Nonnull
    public static String getName(@Nonnull String instance) {
        Preconditions.checkNotNull((Object)instance);
        return DyeColorHelper.getName(instance, false);
    }

    @Nonnull
    public static String getName(@Nonnull String instance, boolean emptyString) {
        Preconditions.checkNotNull((Object)instance);
        try {
            DyeColor color = DyeColor.valueOf((String)StringUtil.dehumanize(instance));
            return DyeColorHelper.getName(color);
        }
        catch (Exception ex) {
            return emptyString ? "" : StringUtil.humanize(instance);
        }
    }

    @Generated
    private DyeColorHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

