/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.minecraft;

import com.google.common.base.Preconditions;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nonnull;
import lombok.Generated;
import org.bukkit.ChatColor;

public enum ChatColors {
    AQUA(ChatColor.AQUA, "\u5929\u84dd\u8272"),
    BLACK(ChatColor.BLACK, "\u9ed1\u8272"),
    BLUE(ChatColor.BLUE, "\u84dd\u8272"),
    BOLD(ChatColor.BOLD, "\u52a0\u7c97"),
    DARK_AQUA(ChatColor.DARK_AQUA, "\u6e56\u84dd\u8272"),
    DARK_BLUE(ChatColor.DARK_BLUE, "\u6df1\u84dd\u8272"),
    DARK_GRAY(ChatColor.DARK_GRAY, "\u6df1\u7070\u8272"),
    DARK_GREEN(ChatColor.DARK_GREEN, "\u6df1\u7eff\u8272"),
    DARK_PURPLE(ChatColor.DARK_PURPLE, "\u7d2b\u8272"),
    DARK_RED(ChatColor.DARK_RED, "\u6df1\u7ea2\u8272"),
    GOLD(ChatColor.GOLD, "\u91d1\u8272"),
    GRAY(ChatColor.GRAY, "\u7070\u8272"),
    GREEN(ChatColor.GREEN, "\u7eff\u8272"),
    ITALIC(ChatColor.ITALIC, "\u659c\u4f53"),
    LIGHT_PURPLE(ChatColor.LIGHT_PURPLE, "\u7c89\u7ea2\u8272"),
    MAGIC(ChatColor.MAGIC, "\u968f\u673a"),
    RED(ChatColor.RED, "\u7ea2\u8272"),
    RESET(ChatColor.RESET, "\u91cd\u7f6e"),
    STRIKETHROUGH(ChatColor.STRIKETHROUGH, "\u5220\u9664\u7ebf"),
    UNDERLINE(ChatColor.UNDERLINE, "\u4e0b\u5212\u7ebf"),
    WHITE(ChatColor.WHITE, "\u767d\u8272"),
    YELLOW(ChatColor.YELLOW, "\u9ec4\u8272");

    public static final char COLOR_CHAR = '\u00a7';
    private static final ChatColors[] valuesCache;
    private static final Map<ChatColor, ChatColors> colorLookup;
    private final ChatColor color;
    private final String chinese;

    @Nonnull
    public static ChatColors fromChatColor(@Nonnull ChatColor chatColor) {
        Preconditions.checkArgument((chatColor != null ? 1 : 0) != 0, (Object)"\u804a\u5929\u989c\u8272\u4e0d\u80fd\u4e3a\u7a7a");
        return colorLookup.get(chatColor);
    }

    public String toString() {
        return this.getChinese();
    }

    public String toColoredString() {
        return String.valueOf(this.getColor()) + this.getChinese();
    }

    @Generated
    public ChatColor getColor() {
        return this.color;
    }

    @Generated
    public String getChinese() {
        return this.chinese;
    }

    @Generated
    private ChatColors(ChatColor color, String chinese) {
        this.color = color;
        this.chinese = chinese;
    }

    static {
        valuesCache = ChatColors.values();
        colorLookup = new EnumMap<ChatColor, ChatColors>(ChatColor.class);
        for (ChatColors color : valuesCache) {
            colorLookup.put(color.getColor(), color);
        }
    }
}

