/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.localization;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.guizhanss.minecraft.guizhanlib.gugu.localization.LocalizationLoader;

public final class MinecraftLocalization {
    private static final Gson GSON = new Gson();
    private static MinecraftLocalization instance;
    private final Map<String, String> lang = new LocalizationLoader().getResult();

    private MinecraftLocalization() {
    }

    public static void load() {
        if (instance != null) {
            throw new IllegalStateException("MinecraftLocalization has already been initialized");
        }
        instance = new MinecraftLocalization();
    }

    @Nullable
    public static String getOrNull(@Nonnull String key) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull((Object)instance, (Object)"MinecraftLocalization has not been initialized");
        return MinecraftLocalization.instance.lang.get(key);
    }

    @Nonnull
    public static String getOrDefault(@Nonnull String key, @Nonnull String defaultVal) {
        Preconditions.checkNotNull((Object)defaultVal);
        String lang = MinecraftLocalization.getOrNull(key);
        return lang != null ? lang : defaultVal;
    }

    @Nonnull
    public static String getOrKey(@Nonnull String key) {
        return MinecraftLocalization.getOrDefault(key, key);
    }
}

