/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.gugu.localization;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.guizhanss.minecraft.guizhanlib.GuizhanLib;
import net.guizhanss.minecraft.guizhanlib.libs.paperlib.PaperLib;
import net.guizhanss.minecraft.guizhanlib.utils.MinecraftVersionUtils;

public final class LocalizationLoader {
    private static final Gson GSON = new Gson();
    private static final HttpClient HTTP_CLIENT = HttpClient.newBuilder().connectTimeout(Duration.ofSeconds(5L)).build();
    private final Map<String, String> lang = new HashMap<String, String>();
    private final Logger logger = GuizhanLib.getInstance().getLogger();
    private final String fullVersion = MinecraftVersionUtils.getFullVersion();
    private final File localeFile;

    public LocalizationLoader() {
        File langFolder = new File(GuizhanLib.getInstance().getDataFolder(), "minecraft-lang");
        if (!langFolder.exists()) {
            langFolder.mkdirs();
        }
        this.localeFile = new File(GuizhanLib.getInstance().getDataFolder(), "minecraft-lang/" + this.fullVersion + ".json");
        this.prepareFile();
        this.loadFile();
    }

    public Map<String, String> getResult() {
        return Collections.unmodifiableMap(this.lang);
    }

    private void prepareFile() {
        this.logger.log(Level.INFO, "\u5f00\u59cb\u52a0\u8f7d Minecraft \u672c\u5730\u5316\u6587\u4ef6");
        this.logger.log(Level.INFO, "\u5f53\u524d\u7248\u672c: " + this.fullVersion);
        try {
            if (!this.localeFile.exists()) {
                this.logger.log(Level.INFO, "\u5f53\u524d\u7248\u672c\u7684\u672c\u5730\u5316\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6b63\u5728\u5c1d\u8bd5\u4e0b\u8f7d");
                String remoteUrl = "https://cdn.jsdelivr.net/gh/InventivetalentDev/minecraft-assets@" + this.fullVersion + "/assets/minecraft/lang/zh_cn.json";
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(remoteUrl)).GET().timeout(Duration.ofSeconds(10L)).build();
                HttpResponse<InputStream> response = HTTP_CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
                InputStream inputStream = response.body();
                this.saveToFile(inputStream);
                this.logger.log(Level.INFO, "\u5df2\u4e0b\u8f7d\u5f53\u524d\u7248\u672c\u7684\u672c\u5730\u5316\u6587\u4ef6");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "\u52a0\u8f7d Minecraft \u672c\u5730\u5316\u8d44\u6e90\u65f6\u53d1\u751f\u9519\u8bef\uff0c\u5c1d\u8bd5\u5907\u7528\u65b9\u6848", e);
            this.prepareBackupFile();
        }
    }

    private void prepareBackupFile() {
        this.logger.log(Level.INFO, "\u5f00\u59cb\u52a0\u8f7d\u672c\u5730\u5907\u7528 Minecraft \u672c\u5730\u5316\u6587\u4ef6\uff08\u53ef\u80fd\u4e0d\u662f\u5f53\u524d\u7248\u672c\u6700\u65b0\uff09");
        try {
            for (int mcVersion = PaperLib.getMinecraftVersion(); mcVersion >= 18; --mcVersion) {
                this.logger.log(Level.INFO, "\u5c1d\u8bd5\u5bfb\u627e 1." + mcVersion);
                String filename = "/minecraft-lang/1." + mcVersion + "/zh_cn.json";
                InputStream input = GuizhanLib.getInstance().getClass().getResourceAsStream(filename);
                if (input != null) {
                    this.logger.log(Level.INFO, "\u6b63\u5728\u52a0\u8f7d 1." + mcVersion);
                    this.saveToFile(input);
                    this.logger.log(Level.INFO, "\u5df2\u52a0\u8f7d 1." + mcVersion);
                    break;
                }
                this.logger.log(Level.INFO, "1." + mcVersion + " \u7684\u672c\u5730\u5316\u6587\u4ef6\u7f3a\u5931\uff0c\u6b63\u5728\u5c1d\u8bd5\u52a0\u8f7d\u4e0a\u4e00\u4e2a\u7248\u672c");
            }
        }
        catch (Exception e) {
            this.logger.log(Level.SEVERE, "\u52a0\u8f7d\u672c\u5730\u5907\u7528 Minecraft \u672c\u5730\u5316\u8d44\u6e90\u5931\u8d25", e);
        }
    }

    private void saveToFile(InputStream inputStream) throws Exception {
        int read;
        FileOutputStream output = new FileOutputStream(this.localeFile);
        byte[] data = new byte[1024];
        while ((read = inputStream.read(data, 0, 1024)) != -1) {
            output.write(data, 0, read);
        }
        inputStream.close();
        output.close();
    }

    private void loadFile() {
        try {
            FileInputStream stream = new FileInputStream(this.localeFile);
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            Type type = new TypeToken<Map<String, String>>(){}.getType();
            this.lang.putAll((Map)GSON.fromJson((Reader)reader, type));
            this.logger.log(Level.INFO, "\u52a0\u8f7d\u6210\u529f");
        }
        catch (Exception ex) {
            this.logger.log(Level.SEVERE, "\u52a0\u8f7d Minecraft \u672c\u5730\u5316\u6587\u4ef6\u65f6\u53d1\u751f\u9519\u8bef", ex);
        }
    }
}

