/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib.config;

import io.github.thebusybiscuit.slimefun4.libraries.dough.config.Config;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.slimefun.addon.AddonConfig;
import net.guizhanss.minecraft.guizhanlib.GuizhanLib;
import org.bukkit.plugin.Plugin;

public final class ConfigManager {
    private final AddonConfig config;
    private final Config updaterConfig;
    private final boolean debugEnabled;
    private final boolean autoUpdateEnabled;
    private final String updaterLocation;
    private final String updaterLang;

    public ConfigManager(@Nonnull GuizhanLib plugin) {
        this.config = new AddonConfig(plugin, "config.yml");
        this.updaterConfig = new Config((Plugin)plugin, "updater.yml");
        this.debugEnabled = this.config.getBoolean("debug", false);
        this.autoUpdateEnabled = this.config.getBoolean("auto-update", true);
        this.updaterLocation = this.config.getString("updater.location", "global");
        this.updaterLang = this.config.getString("updater.lang", "en_US");
        if (this.debugEnabled) {
            plugin.getLogger().info("Debug mode is enabled.");
            plugin.getLogger().info("Auto update is " + (this.autoUpdateEnabled ? "enabled" : "disabled") + ".");
            plugin.getLogger().info("Updater location is " + this.updaterLocation + ".");
        }
    }

    @Generated
    public Config getUpdaterConfig() {
        return this.updaterConfig;
    }

    @Generated
    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    @Generated
    public boolean isAutoUpdateEnabled() {
        return this.autoUpdateEnabled;
    }

    @Generated
    public String getUpdaterLocation() {
        return this.updaterLocation;
    }

    @Generated
    public String getUpdaterLang() {
        return this.updaterLang;
    }
}

