/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.minecraft.guizhanlib;

import io.github.thebusybiscuit.slimefun4.implementation.Slimefun;
import java.util.HashMap;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import lombok.Generated;
import net.guizhanss.guizhanlib.slimefun.addon.AbstractAddon;
import net.guizhanss.minecraft.guizhanlib.config.ConfigManager;
import net.guizhanss.minecraft.guizhanlib.gugu.localization.MinecraftLocalization;
import net.guizhanss.minecraft.guizhanlib.libs.bstats.bukkit.Metrics;
import net.guizhanss.minecraft.guizhanlib.libs.bstats.charts.DrilldownPie;
import net.guizhanss.minecraft.guizhanlib.libs.bstats.charts.SimplePie;
import net.guizhanss.minecraft.guizhanlib.updater.GuizhanUpdater;
import net.guizhanss.minecraft.guizhanlib.updater.universal.v2.UniversalUpdater;
import org.bukkit.plugin.Plugin;

public class GuizhanLib
extends AbstractAddon {
    private final UniversalUpdater universalUpdater = new UniversalUpdater();
    private ConfigManager configManager;
    private final boolean isUnitTest = this.getClassLoader().getClass().getPackageName().startsWith("be.seeseemelk.mockbukkit");

    public GuizhanLib() {
        super("ybw0014", "GuizhanLibPlugin", "master", "auto-update");
    }

    @Nonnull
    public static ConfigManager getConfigManager() {
        return GuizhanLib.inst().configManager;
    }

    @Nonnull
    public static UniversalUpdater getUniversalUpdater() {
        return GuizhanLib.inst().universalUpdater;
    }

    @Nonnull
    private static GuizhanLib inst() {
        return (GuizhanLib)((Object)GuizhanLib.getInstance());
    }

    @Override
    public void enable() {
        this.configManager = new ConfigManager(this);
        this.setupMinecraftLanguage();
        if (!this.isUnitTest) {
            this.setupMetrics();
            this.universalUpdater.start();
        }
    }

    @Override
    public void disable() {
    }

    private void setupMinecraftLanguage() {
        block2: {
            try {
                MinecraftLocalization.load();
            }
            catch (Exception ex) {
                if (!this.configManager.isDebugEnabled()) break block2;
                this.getLogger().log(Level.SEVERE, ex, ex::getMessage);
            }
        }
    }

    private void setupMetrics() {
        Metrics metrics = new Metrics((Plugin)this, 15713);
        metrics.addCustomChart(new SimplePie("auto_update", () -> String.valueOf(this.configManager.isAutoUpdateEnabled())));
        metrics.addCustomChart(new SimplePie("updater_location", () -> this.configManager.getUpdaterLocation()));
        metrics.addCustomChart(new SimplePie("updater_lang", () -> this.configManager.getUpdaterLang()));
        metrics.addCustomChart(new DrilldownPie("slimefun_version", () -> {
            HashMap outerMap = new HashMap();
            HashMap<String, Integer> innerMap = new HashMap<String, Integer>();
            String sfVersion = Slimefun.getVersion();
            String branch = "Other";
            innerMap.put(sfVersion, 1);
            if (sfVersion.startsWith("Dev")) {
                branch = "Official Dev";
            } else if (sfVersion.startsWith("RC")) {
                branch = "Official RC";
            } else if (sfVersion.endsWith("-Insider")) {
                branch = "Insider";
            } else if (sfVersion.endsWith("-canary") || sfVersion.endsWith("-Beta")) {
                branch = "Beta";
            } else if (sfVersion.endsWith("-release") || sfVersion.startsWith("Build")) {
                branch = "Release";
            }
            outerMap.put(branch, innerMap);
            return outerMap;
        }));
    }

    @Override
    protected void autoUpdate() {
        if (this.getPluginVersion().startsWith("Build")) {
            GuizhanUpdater.start((Plugin)this, this.getFile(), "ybw0014", "GuizhanLibPlugin", "master");
        }
    }

    @Generated
    public boolean isUnitTest() {
        return this.isUnitTest;
    }
}

