/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.slimefun.machines;

import io.github.thebusybiscuit.slimefun4.api.SlimefunAddon;
import io.github.thebusybiscuit.slimefun4.api.items.ItemGroup;
import io.github.thebusybiscuit.slimefun4.api.items.SlimefunItemStack;
import io.github.thebusybiscuit.slimefun4.api.recipes.RecipeType;
import io.github.thebusybiscuit.slimefun4.core.attributes.EnergyNetComponent;
import io.github.thebusybiscuit.slimefun4.core.networks.energy.EnergyNetComponentType;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import me.mrCookieSlime.Slimefun.api.inventory.BlockMenu;
import net.guizhanss.guizhanlib.slimefun.machines.TickingMenuBlock;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;

@ParametersAreNonnullByDefault
public abstract class AbstractMachineBlock
extends TickingMenuBlock
implements EnergyNetComponent {
    protected int energyPerTick = -1;
    protected int energyCapacity = -1;

    @ParametersAreNonnullByDefault
    protected AbstractMachineBlock(ItemGroup itemGroup, SlimefunItemStack item, RecipeType recipeType, ItemStack[] recipe) {
        super(itemGroup, item, recipeType, recipe);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void tick(Block b, BlockMenu menu) {
        if (this.getCharge(menu.getLocation()) < this.energyPerTick) {
            if (menu.hasViewer()) {
                menu.replaceExistingItem(this.getStatusSlot(), this.getNoEnergyItem());
            }
        } else if (this.process(b, menu)) {
            this.removeCharge(menu.getLocation(), this.energyPerTick);
        }
    }

    protected abstract boolean process(Block var1, BlockMenu var2);

    protected abstract int getStatusSlot();

    protected abstract ItemStack getNoEnergyItem();

    public final int getCapacity() {
        return this.energyCapacity;
    }

    @Nonnull
    public final EnergyNetComponentType getEnergyComponentType() {
        return EnergyNetComponentType.CONSUMER;
    }

    public final void register(@Nonnull SlimefunAddon addon) {
        if (this.energyPerTick == -1) {
            throw new IllegalStateException("You must call .setEnergyPerTick() before registering!");
        }
        if (this.energyCapacity == -1) {
            this.energyCapacity = this.energyPerTick * 2;
        }
        super.register(addon);
    }

    @Generated
    public void setEnergyPerTick(int energyPerTick) {
        this.energyPerTick = energyPerTick;
    }

    @Generated
    public void setEnergyCapacity(int energyCapacity) {
        this.energyCapacity = energyCapacity;
    }
}

