/*
 * Decompiled with CFR 0.152.
 */
package net.guizhanss.guizhanlib.common;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class RateLimit<K> {
    private final long limitTime;
    private final int limitVisits;
    private final Map<K, Long> timeMap = new HashMap<K, Long>();
    private final Map<K, Integer> visitMap = new HashMap<K, Integer>();

    public RateLimit(long time, int visits) {
        this.limitTime = time;
        this.limitVisits = visits;
    }

    public int getLimit() {
        return this.limitVisits;
    }

    public int getUsed(@Nonnull K key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key should not be null");
        Long time = this.timeMap.get(key);
        Integer visits = this.visitMap.get(key);
        if (time == null || visits == null) {
            return 0;
        }
        if (System.nanoTime() - time >= this.limitTime) {
            return 0;
        }
        return visits;
    }

    public int getRemaining(@Nonnull K key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key should not be null");
        return this.getLimit() - this.getUsed(key);
    }

    public boolean add(@Nonnull K key, int visits) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key should not be null");
        Long time = this.timeMap.get(key);
        Integer visited = this.visitMap.get(key);
        if (time == null || visited == null) {
            this.reset(key);
            this.timeMap.put(key, System.nanoTime());
            this.visitMap.put(key, visits);
            return true;
        }
        if (this.getRemaining(key) < visits) {
            return false;
        }
        this.visitMap.put(key, visited + visits);
        return true;
    }

    public boolean add(@Nonnull K key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key should not be null");
        return this.add(key, 1);
    }

    public void reset(@Nonnull K key) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (Object)"key should not be null");
        this.timeMap.remove(key);
        this.visitMap.remove(key);
    }
}

