/*
 * Decompiled with CFR 0.152.
 */
package net.cubespace.Yamler.Config;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.cubespace.Yamler.Config.ConfigBasic;
import net.cubespace.Yamler.Config.ConfigSection;
import net.cubespace.Yamler.Config.InvalidConfigurationException;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.CustomClassLoaderConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.representer.Representer;

public class YamlConfigMapper
extends ConfigBasic {
    private transient Yaml yaml;
    protected transient ConfigSection root;
    private transient Map<String, ArrayList<String>> comments = new LinkedHashMap<String, ArrayList<String>>();
    private transient Representer yamlRepresenter = new Representer();

    protected YamlConfigMapper() {
        DumperOptions yamlOptions = new DumperOptions();
        yamlOptions.setIndent(2);
        yamlOptions.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yamlRepresenter.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        this.yaml = new Yaml((BaseConstructor)new CustomClassLoaderConstructor(YamlConfigMapper.class.getClassLoader()), this.yamlRepresenter, yamlOptions);
    }

    protected void loadFromYaml() throws InvalidConfigurationException {
        this.root = new ConfigSection();
        try (InputStreamReader fileReader = new InputStreamReader((InputStream)new FileInputStream(this.CONFIG_FILE), Charset.forName("UTF-8"));){
            Object object = this.yaml.load((Reader)fileReader);
            if (object != null) {
                this.convertMapsToSections((Map)object, this.root);
            }
        }
        catch (IOException | ClassCastException | YAMLException e) {
            throw new InvalidConfigurationException("Could not load YML", e);
        }
    }

    private void convertMapsToSections(Map<?, ?> input, ConfigSection section) {
        if (input == null) {
            return;
        }
        for (Map.Entry<?, ?> entry : input.entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Map) {
                this.convertMapsToSections((Map)value, section.create(key));
                continue;
            }
            section.set(key, value);
        }
    }

    protected void saveToYaml() throws InvalidConfigurationException {
        try (OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.CONFIG_FILE), Charset.forName("UTF-8"));){
            if (this.CONFIG_HEADER != null) {
                for (String line : this.CONFIG_HEADER) {
                    fileWriter.write("# " + line + "\n");
                }
                fileWriter.write("\n");
            }
            Integer depth = 0;
            ArrayList<String> keyChain = new ArrayList<String>();
            String yamlString = this.yaml.dump(this.root.getValues(true));
            StringBuilder writeLines = new StringBuilder();
            for (String line : yamlString.split("\n")) {
                if (line.startsWith(new String(new char[depth.intValue()]).replace("\u0000", " "))) {
                    keyChain.add(line.split(":")[0].trim());
                    depth = depth + 2;
                } else {
                    if (line.startsWith(new String(new char[depth - 2]).replace("\u0000", " "))) {
                        keyChain.remove(keyChain.size() - 1);
                    } else {
                        int spaces = 0;
                        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
                            ++spaces;
                        }
                        depth = spaces;
                        if (spaces == 0) {
                            keyChain = new ArrayList();
                            depth = 2;
                        } else {
                            ArrayList<String> temp = new ArrayList<String>();
                            int index = 0;
                            int i = 0;
                            while (i < spaces) {
                                temp.add(keyChain.get(index));
                                i += 2;
                                ++index;
                            }
                            keyChain = temp;
                            depth = depth + 2;
                        }
                    }
                    keyChain.add(line.split(":")[0].trim());
                }
                String search = keyChain.size() > 0 ? YamlConfigMapper.join(keyChain, ".") : "";
                if (this.comments.containsKey(search)) {
                    for (String comment : this.comments.get(search)) {
                        writeLines.append(new String(new char[depth - 2]).replace("\u0000", " "));
                        writeLines.append("# ");
                        writeLines.append(comment);
                        writeLines.append("\n");
                    }
                }
                writeLines.append(line);
                writeLines.append("\n");
            }
            fileWriter.write(writeLines.toString());
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Could not save YML", e);
        }
    }

    private static String join(List<String> list, String conjunction) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String item : list) {
            if (first) {
                first = false;
            } else {
                sb.append(conjunction);
            }
            sb.append(item);
        }
        return sb.toString();
    }

    public void addComment(String key, String value) {
        if (!this.comments.containsKey(key)) {
            this.comments.put(key, new ArrayList());
        }
        this.comments.get(key).add(value);
    }

    public void clearComments() {
        this.comments.clear();
    }
}

