/*
 * Decompiled with CFR 0.152.
 */
package me.moros.storage;

import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;

public enum StorageType {
    MARIADB("MariaDB", "mariadb.sql"),
    MYSQL("MySQL", "mariadb.sql"),
    POSTGRESQL("PostgreSQL", "postgre.sql"),
    SQLITE("SQLite", "sqlite.sql"),
    H2("H2", "h2.sql");

    private final String name;
    private final String path;

    private StorageType(String name, String schemaFileName) {
        this.name = name;
        this.path = schemaFileName;
    }

    public @NonNull String getSchemaPath() {
        return this.path;
    }

    public String toString() {
        return this.name;
    }

    public static @NonNull StorageType parse(@NonNull String name, @NonNull StorageType def) {
        return Arrays.stream(StorageType.values()).filter(t -> name.equalsIgnoreCase(t.name)).findAny().orElse(def);
    }
}

