/*
 * Decompiled with CFR 0.152.
 */
package me.moros.storage;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import me.moros.storage.Storage;
import me.moros.storage.StorageCreator;
import me.moros.storage.StorageType;
import me.moros.storage.logging.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ConnectionBuilder<T extends Storage> {
    private static final Set<String> poolNames = new HashSet<String>();
    private final StorageCreator<T> constructor;
    private final StorageType engine;
    private String path = "";
    private String host = "localhost";
    private String database = "";
    private String username = "";
    private String password = "";
    private int port;

    private ConnectionBuilder(StorageCreator<T> constructor, StorageType engine) {
        this.constructor = constructor;
        this.engine = engine;
    }

    public @NonNull ConnectionBuilder<T> setPath(@NonNull String path) {
        this.path = path;
        return this;
    }

    public @NonNull ConnectionBuilder<T> setHost(@NonNull String host) {
        this.host = host;
        return this;
    }

    public @NonNull ConnectionBuilder<T> setDatabase(@NonNull String database) {
        this.database = database;
        return this;
    }

    public @NonNull ConnectionBuilder<T> setUsername(@NonNull String username) {
        this.username = username;
        return this;
    }

    public @NonNull ConnectionBuilder<T> setPassword(@NonNull String password) {
        this.password = password;
        return this;
    }

    public @NonNull ConnectionBuilder<T> setPort(int port) {
        this.port = port;
        return this;
    }

    public @Nullable T build(@NonNull String poolName, @NonNull Logger logger) {
        return this.build(poolName, logger, true);
    }

    public @Nullable T build(@NonNull String poolName, @NonNull Logger logger, boolean optimize) {
        if (poolNames.contains(poolName)) {
            logger.warn(poolName + " is already registered!");
            return null;
        }
        if (this.host.isEmpty() || this.database.isEmpty() || this.username.isEmpty() || this.password.isEmpty()) {
            logger.warn("Connection info is invalid! One or more values is empty!");
            return null;
        }
        if ((this.engine == StorageType.H2 || this.engine == StorageType.SQLITE) && this.path.isEmpty()) {
            logger.warn("Connection path is missing!");
            return null;
        }
        logger.info("Loading storage provider... [" + (Object)((Object)this.engine) + "]");
        HikariConfig config = new HikariConfig();
        config.setPoolName(poolName);
        config.setMaximumPoolSize(5);
        config.setMinimumIdle(3);
        config.addDataSourceProperty("serverName", (Object)this.host);
        config.addDataSourceProperty("portNumber", (Object)this.port);
        config.addDataSourceProperty("databaseName", (Object)this.database);
        config.addDataSourceProperty("user", (Object)this.username);
        config.addDataSourceProperty("password", (Object)this.password);
        if (optimize && (this.engine == StorageType.MARIADB || this.engine == StorageType.MYSQL)) {
            config.addDataSourceProperty("cachePrepStmts", (Object)true);
            config.addDataSourceProperty("prepStmtCacheSize", (Object)250);
            config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)2048);
            config.addDataSourceProperty("useServerPrepStmts", (Object)true);
            config.addDataSourceProperty("cacheCallableStmts", (Object)true);
            config.addDataSourceProperty("cacheResultSetMetadata", (Object)true);
            config.addDataSourceProperty("cacheServerConfiguration", (Object)true);
            config.addDataSourceProperty("useLocalSessionState", (Object)true);
            config.addDataSourceProperty("elideSetAutoCommits", (Object)true);
            config.addDataSourceProperty("alwaysSendSetIsolation", (Object)false);
        }
        switch (this.engine) {
            case POSTGRESQL: {
                config.setDataSourceClassName("org.postgresql.ds.PGSimpleDataSource");
                break;
            }
            case MARIADB: {
                config.setDataSourceClassName("org.mariadb.jdbc.MariaDbDataSource");
                break;
            }
            case MYSQL: {
                config.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
                break;
            }
            case H2: {
                config.setDriverClassName("org.h2.Driver");
                config.setJdbcUrl("jdbc:h2:./" + this.path);
                break;
            }
            case SQLITE: {
                config.setDriverClassName("org.sqlite.JDBC");
                config.setJdbcUrl("jdbc:sqlite:" + this.path);
            }
        }
        HikariDataSource ds = new HikariDataSource(config);
        try {
            if (ds.getConnection() != null) {
                poolNames.add(poolName);
                return this.constructor.create(this.engine, logger, ds);
            }
        }
        catch (SQLException e) {
            logger.severe(e.getMessage());
        }
        return null;
    }

    public static <T extends Storage> @NonNull ConnectionBuilder<T> create(@NonNull StorageCreator<T> constructor, @NonNull StorageType engine) {
        return new ConnectionBuilder<T>(constructor, engine);
    }
}

