/*
 * Decompiled with CFR 0.152.
 */
package me.minidigger.minimessage;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;

public class MiniMessageSerializer {
    @Nonnull
    public static String serialize(BaseComponent ... components) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < components.length; ++i) {
            ClickEvent click;
            HoverEvent hov;
            BaseComponent comp = components[i];
            BaseComponent prevComp = null;
            if (i > 0) {
                prevComp = components[i - 1];
            }
            if (!ChatColor.WHITE.equals((Object)comp.getColor())) {
                sb.append(MiniMessageSerializer.startColor(comp.getColor()));
            }
            if (comp.isBold() && (prevComp == null || !prevComp.isBold())) {
                sb.append(MiniMessageSerializer.startTag("bold"));
            }
            if (comp.isItalic() && (prevComp == null || !prevComp.isItalic())) {
                sb.append(MiniMessageSerializer.startTag("italic"));
            }
            if (comp.isObfuscated() && (prevComp == null || !prevComp.isObfuscated())) {
                sb.append(MiniMessageSerializer.startTag("obfuscated"));
            }
            if (comp.isStrikethrough() && (prevComp == null || !prevComp.isStrikethrough())) {
                sb.append(MiniMessageSerializer.startTag("strikethrough"));
            }
            if (comp.isUnderlined() && (prevComp == null || !prevComp.isUnderlined())) {
                sb.append(MiniMessageSerializer.startTag("underlined"));
            }
            if ((hov = comp.getHoverEvent()) != null && (prevComp == null || MiniMessageSerializer.areDifferent(hov, prevComp.getHoverEvent()))) {
                sb.append(MiniMessageSerializer.startTag(String.format("%s:%s:\"%s\"", "hover", hov.getAction().name().toLowerCase(), MiniMessageSerializer.serialize(hov.getValue()))));
            }
            if ((click = comp.getClickEvent()) != null && (prevComp == null || MiniMessageSerializer.areDifferent(click, prevComp.getClickEvent()))) {
                sb.append(MiniMessageSerializer.startTag(String.format("%s:%s:\"%s\"", "click", click.getAction().name().toLowerCase(), click.getValue())));
            }
            sb.append(comp.toPlainText());
            BaseComponent nextComp = null;
            if (i + 1 < components.length) {
                nextComp = components[i + 1];
            }
            if (nextComp != null && comp.getColor() != ChatColor.WHITE && (nextComp.getColor() == ChatColor.WHITE || nextComp.getColor() == null)) {
                sb.append(MiniMessageSerializer.endColor(comp.getColor()));
            }
            if (nextComp != null) {
                if (comp.isBold() && !nextComp.isBold()) {
                    sb.append(MiniMessageSerializer.endTag("bold"));
                }
                if (comp.isItalic() && !nextComp.isItalic()) {
                    sb.append(MiniMessageSerializer.endTag("italic"));
                }
                if (comp.isObfuscated() && !nextComp.isObfuscated()) {
                    sb.append(MiniMessageSerializer.endTag("obfuscated"));
                }
                if (comp.isStrikethrough() && !nextComp.isStrikethrough()) {
                    sb.append(MiniMessageSerializer.endTag("strikethrough"));
                }
                if (comp.isUnderlined() && !nextComp.isUnderlined()) {
                    sb.append(MiniMessageSerializer.endTag("underlined"));
                }
            }
            if (nextComp != null && comp.getHoverEvent() != null && MiniMessageSerializer.areDifferent(comp.getHoverEvent(), nextComp.getHoverEvent())) {
                sb.append(MiniMessageSerializer.endTag("hover"));
            }
            if (nextComp == null || comp.getClickEvent() == null || !MiniMessageSerializer.areDifferent(comp.getClickEvent(), nextComp.getClickEvent())) continue;
            sb.append(MiniMessageSerializer.endTag("click"));
        }
        return sb.toString();
    }

    private static boolean areDifferent(@Nonnull ClickEvent c1, @Nullable ClickEvent c2) {
        if (c2 == null) {
            return true;
        }
        return !c1.equals((Object)c2) && (!c1.getAction().equals((Object)c2.getAction()) || !c1.getValue().equals(c2.getValue()));
    }

    private static boolean areDifferent(@Nonnull HoverEvent h1, @Nullable HoverEvent h2) {
        if (h2 == null) {
            return true;
        }
        return !h1.equals((Object)h2) && !h1.getAction().equals((Object)h2.getAction());
    }

    @Nonnull
    private static String startColor(@Nonnull ChatColor color) {
        return MiniMessageSerializer.startTag(color.name().toLowerCase());
    }

    @Nonnull
    private static String endColor(@Nonnull ChatColor color) {
        return MiniMessageSerializer.endTag(color.name().toLowerCase());
    }

    @Nonnull
    private static String startTag(@Nonnull String content) {
        return "<" + content + ">";
    }

    @Nonnull
    private static String endTag(@Nonnull String content) {
        return "</" + content + ">";
    }
}

