/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.paper.common.sampler.async;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.IntPredicate;
import java.util.logging.Level;
import me.lucko.spark.paper.common.SparkPlatform;
import me.lucko.spark.paper.common.sampler.AbstractSampler;
import me.lucko.spark.paper.common.sampler.Sampler;
import me.lucko.spark.paper.common.sampler.SamplerMode;
import me.lucko.spark.paper.common.sampler.SamplerSettings;
import me.lucko.spark.paper.common.sampler.SamplerType;
import me.lucko.spark.paper.common.sampler.async.AsyncDataAggregator;
import me.lucko.spark.paper.common.sampler.async.AsyncNodeExporter;
import me.lucko.spark.paper.common.sampler.async.AsyncProfilerAccess;
import me.lucko.spark.paper.common.sampler.async.AsyncProfilerJob;
import me.lucko.spark.paper.common.sampler.async.SampleCollector;
import me.lucko.spark.paper.common.sampler.async.TickedAsyncDataAggregator;
import me.lucko.spark.paper.common.sampler.window.ProfilingWindowUtils;
import me.lucko.spark.paper.common.tick.TickHook;
import me.lucko.spark.paper.common.util.SparkThreadFactory;
import me.lucko.spark.paper.common.ws.ViewerSocket;
import me.lucko.spark.paper.proto.SparkSamplerProtos;

public class AsyncSampler
extends AbstractSampler {
    private final SampleCollector<?> sampleCollector;
    private final AsyncProfilerAccess profilerAccess;
    private final AsyncDataAggregator dataAggregator;
    private final boolean forceNanoTime;
    private final Object[] currentJobMutex = new Object[0];
    private AsyncProfilerJob currentJob;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> socketStatisticsTask;

    public AsyncSampler(SparkPlatform platform, SamplerSettings settings, SampleCollector<?> collector) {
        this(platform, settings, collector, new AsyncDataAggregator(settings.threadGrouper(), settings.ignoreSleeping()), false);
    }

    public AsyncSampler(SparkPlatform platform, SamplerSettings settings, SampleCollector<?> collector, int tickLengthThreshold) {
        this(platform, settings, collector, new TickedAsyncDataAggregator(settings.threadGrouper(), settings.ignoreSleeping(), platform.getTickReporter(), tickLengthThreshold), true);
    }

    private AsyncSampler(SparkPlatform platform, SamplerSettings settings, SampleCollector<?> collector, AsyncDataAggregator dataAggregator, boolean forceNanoTime) {
        super(platform, settings);
        this.sampleCollector = collector;
        this.dataAggregator = dataAggregator;
        this.forceNanoTime = forceNanoTime;
        this.profilerAccess = AsyncProfilerAccess.getInstance(platform);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("spark-async-sampler-worker-thread").setUncaughtExceptionHandler(SparkThreadFactory.EXCEPTION_HANDLER).build());
    }

    @Override
    public void start() {
        boolean shouldNotRotate;
        super.start();
        TickHook tickHook = this.platform.getTickHook();
        if (tickHook != null) {
            this.windowStatisticsCollector.startCountingTicks(tickHook);
        }
        int window = ProfilingWindowUtils.windowNow();
        AsyncProfilerJob job = this.profilerAccess.startNewProfilerJob();
        job.init(this.platform, this.sampleCollector, this.threadDumper, window, this.background, this.forceNanoTime);
        job.start();
        this.windowStatisticsCollector.recordWindowStartTime(window);
        this.currentJob = job;
        boolean bl = shouldNotRotate = this.sampleCollector instanceof SampleCollector.Allocation && ((SampleCollector.Allocation)this.sampleCollector).isLiveOnly();
        if (!shouldNotRotate) {
            this.scheduler.scheduleAtFixedRate(this::rotateProfilerJob, 60L, 60L, TimeUnit.SECONDS);
        }
        this.recordInitialGcStats();
        this.scheduleTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rotateProfilerJob() {
        try {
            Object[] objectArray = this.currentJobMutex;
            synchronized (this.currentJobMutex) {
                AsyncProfilerJob previousJob = this.currentJob;
                if (previousJob == null) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                try {
                    previousJob.stop();
                }
                catch (Exception e) {
                    this.platform.getPlugin().log(Level.WARNING, "Failed to stop previous profiler job", e);
                }
                int window = previousJob.getWindow() + 1;
                AsyncProfilerJob newJob = this.profilerAccess.startNewProfilerJob();
                newJob.init(this.platform, this.sampleCollector, this.threadDumper, window, this.background, this.forceNanoTime);
                newJob.start();
                this.windowStatisticsCollector.recordWindowStartTime(window);
                this.currentJob = newJob;
                try {
                    this.windowStatisticsCollector.measureNow(previousJob.getWindow());
                }
                catch (Exception e) {
                    this.platform.getPlugin().log(Level.WARNING, "Failed to measure window statistics", e);
                }
                previousJob.aggregate(this.dataAggregator);
                IntPredicate predicate = ProfilingWindowUtils.keepHistoryBefore(window);
                this.dataAggregator.pruneData(predicate);
                this.windowStatisticsCollector.pruneStatistics(predicate);
                this.scheduler.execute(() -> this.processWindowRotate());
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (Throwable e) {
            this.platform.getPlugin().log(Level.WARNING, "Exception occurred while rotating profiler job", e);
        }
        {
            return;
        }
    }

    private void scheduleTimeout() {
        if (this.autoEndTime == -1L) {
            return;
        }
        long delay = this.autoEndTime - System.currentTimeMillis();
        if (delay <= 0L) {
            return;
        }
        this.scheduler.schedule(() -> {
            try {
                this.stop(false);
                this.future.complete(this);
            }
            catch (Exception e) {
                this.future.completeExceptionally(e);
            }
        }, delay, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(boolean cancelled) {
        super.stop(cancelled);
        Object[] objectArray = this.currentJobMutex;
        synchronized (this.currentJobMutex) {
            this.currentJob.stop();
            if (!cancelled) {
                this.windowStatisticsCollector.measureNow(this.currentJob.getWindow());
                this.currentJob.aggregate(this.dataAggregator);
            } else {
                this.currentJob.deleteOutputFile();
            }
            this.currentJob = null;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (this.socketStatisticsTask != null) {
                this.socketStatisticsTask.cancel(false);
            }
            if (this.scheduler != null) {
                this.scheduler.shutdown();
                this.scheduler = null;
            }
            this.dataAggregator.close();
            return;
        }
    }

    @Override
    public void attachSocket(ViewerSocket socket) {
        super.attachSocket(socket);
        if (this.socketStatisticsTask == null) {
            this.socketStatisticsTask = this.scheduler.scheduleAtFixedRate(() -> this.sendStatisticsToSocket(), 10L, 10L, TimeUnit.SECONDS);
        }
    }

    @Override
    public SamplerType getType() {
        return SamplerType.ASYNC;
    }

    @Override
    public String getLibraryVersion() {
        return this.profilerAccess.getVersion();
    }

    @Override
    public SamplerMode getMode() {
        return this.sampleCollector.getMode();
    }

    @Override
    public SparkSamplerProtos.SamplerData toProto(SparkPlatform platform, Sampler.ExportProps exportProps) {
        SparkSamplerProtos.SamplerData.Builder proto = SparkSamplerProtos.SamplerData.newBuilder();
        if (exportProps.channelInfo() != null) {
            proto.setChannelInfo(exportProps.channelInfo());
        }
        this.writeMetadataToProto(proto, platform, exportProps.creator(), exportProps.comment(), this.dataAggregator);
        this.writeDataToProto(proto, this.dataAggregator, AsyncNodeExporter::new, exportProps.classSourceLookup().get(), platform::createClassFinder);
        return (SparkSamplerProtos.SamplerData)proto.build();
    }
}

