/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.diagnostics;

import org.mongodb.assertions.Assertions;
import org.mongodb.diagnostics.logging.JULLogger;
import org.mongodb.diagnostics.logging.Logger;
import org.mongodb.diagnostics.logging.SLF4JLogger;

public final class Loggers {
    public static final String PREFIX = "org.mongodb.driver";
    private static final boolean USE_SLF4J = Loggers.shouldUseSLF4J();

    public static Logger getLogger(String suffix) {
        Assertions.notNull("suffix", suffix);
        if (suffix.startsWith(".") || suffix.endsWith(".")) {
            throw new IllegalArgumentException("The suffix can not start or end with a '.'");
        }
        String name = "org.mongodb.driver." + suffix;
        if (USE_SLF4J) {
            return new SLF4JLogger(name);
        }
        return new JULLogger(name);
    }

    private Loggers() {
    }

    private static boolean shouldUseSLF4J() {
        try {
            Class.forName("org.slf4j.LoggerFactory");
            Class.forName("org.slf4j.impl.StaticLoggerBinder");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

