/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb.connection;

import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class ServerAddress
implements Serializable {
    private static final long serialVersionUID = 4027873363095395504L;
    private final String host;
    private final int port;

    public static String getDefaultHost() {
        return "127.0.0.1";
    }

    public static int getDefaultPort() {
        return 27017;
    }

    public ServerAddress() {
        this(ServerAddress.getDefaultHost(), ServerAddress.getDefaultPort());
    }

    public ServerAddress(String host) {
        this(host, ServerAddress.getDefaultPort());
    }

    public ServerAddress(String host, int port) {
        String hostToUse = host;
        if (hostToUse == null) {
            hostToUse = ServerAddress.getDefaultHost();
        }
        if ((hostToUse = hostToUse.trim()).length() == 0) {
            hostToUse = ServerAddress.getDefaultHost();
        }
        int portToUse = port;
        if (hostToUse.startsWith("[")) {
            int idx = host.indexOf("]");
            if (idx == -1) {
                throw new IllegalArgumentException("an IPV6 address must be encosed with '[' and ']' according to RFC 2732.");
            }
            int portIdx = host.indexOf("]:");
            if (portIdx != -1) {
                if (port != ServerAddress.getDefaultPort()) {
                    throw new IllegalArgumentException("can't specify port in construct and via host");
                }
                portToUse = Integer.parseInt(host.substring(portIdx + 2));
            }
            hostToUse = host.substring(1, idx);
        } else {
            int idx = hostToUse.indexOf(":");
            if (idx > 0) {
                if (port != ServerAddress.getDefaultPort()) {
                    throw new IllegalArgumentException("can't specify port in construct and via host");
                }
                portToUse = Integer.parseInt(hostToUse.substring(idx + 1));
                hostToUse = hostToUse.substring(0, idx).trim();
            }
        }
        this.host = hostToUse;
        this.port = portToUse;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerAddress that = (ServerAddress)o;
        if (this.port != that.port) {
            return false;
        }
        return this.host.equals(that.host);
    }

    public int hashCode() {
        int result = this.host.hashCode();
        result = 31 * result + this.port;
        return result;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public InetSocketAddress getSocketAddress() throws UnknownHostException {
        return new InetSocketAddress(InetAddress.getByName(this.host), this.port);
    }

    public String toString() {
        return this.host + ":" + this.port;
    }
}

