/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb;

import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.WriteConcern;
import org.mongodb.Document;
import org.mongodb.MongoCursor;
import org.mongodb.MongoQueryCursor;

public class MongoView<T> {
    private DBCursor surrogate;
    private WriteConcern writeConcern;

    public MongoView(DBCursor cursor) {
        this.surrogate = cursor;
    }

    public MongoView(DBCursor cursor, WriteConcern writeConcern) {
        this.surrogate = cursor;
    }

    public MongoCursor<T> get() {
        return new MongoQueryCursor(this.surrogate);
    }

    public T getOne() {
        return this.get().next();
    }

    public MongoView<T> sort(Document sort) {
        this.surrogate = this.surrogate.sort(sort.getSurrogate());
        return this;
    }

    public MongoView<T> withWriteConcern(WriteConcern writeConcern) {
        this.writeConcern = writeConcern;
        return this;
    }

    public void update(Document updateQuery) {
        DBObject query = this.surrogate.getQuery();
        this.surrogate.getCollection().update(query, updateQuery.getSurrogate(), false, true, this.writeConcern);
    }
}

