/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb;

import org.bson.BSONObject;
import org.mongodb.ServerError;

public class MongoException
extends RuntimeException {
    private static final long serialVersionUID = -4415279469780082174L;
    private final int code;

    public MongoException(String msg) {
        super(msg);
        this.code = -3;
    }

    public MongoException(int code, String msg) {
        super(msg);
        this.code = code;
    }

    public MongoException(String msg, Throwable t) {
        super(msg, t);
        this.code = -4;
    }

    public MongoException(int code, String msg, Throwable t) {
        super(msg, t);
        this.code = code;
    }

    public MongoException(BSONObject o) {
        this(ServerError.getCode(o), ServerError.getMsg(o, "UNKNOWN"));
    }

    static MongoException parse(BSONObject o) {
        String s = ServerError.getMsg(o, null);
        if (s == null) {
            return null;
        }
        return new MongoException(ServerError.getCode(o), s);
    }

    public int getCode() {
        return this.code;
    }
}

