/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb;

import com.mongodb.DB;
import com.mongodb.DBCollection;
import org.mongodb.CommandResult;
import org.mongodb.Document;
import org.mongodb.MongoCollection;
import org.mongodb.MongoCollectionOptions;

public class MongoDatabase {
    private DB surrogate;

    public MongoDatabase(DB surrogate) {
        this.setSurrogate(surrogate);
    }

    public CommandResult executeCommand(Document cmd) {
        CommandResult result = new CommandResult(this.getSurrogate().command(cmd.getSurrogate()));
        return result;
    }

    public Object getName() {
        return this.getSurrogate().getName();
    }

    public MongoCollection<Document> getCollection(String name, MongoCollectionOptions options) {
        DBCollection collection = this.getSurrogate().getCollection(name);
        collection.setReadPreference(options.getReadPreference());
        collection.setWriteConcern(options.getWriteConcern());
        return new MongoCollection<Document>(collection);
    }

    public DB getSurrogate() {
        return this.surrogate;
    }

    public void setSurrogate(DB surrogate) {
        this.surrogate = surrogate;
    }
}

