/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb;

import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import org.mongodb.CollectionAdministration;
import org.mongodb.Document;
import org.mongodb.MongoDatabase;
import org.mongodb.MongoView;
import org.mongodb.WriteResult;

public class MongoCollection<T> {
    private DBCollection surrogate;

    public MongoCollection(DBCollection db) {
        this.surrogate = db;
    }

    public void save(Document document) {
        DBObject dbObject = document.getSurrogate();
        Object id = dbObject.get("_id");
        if (id == null) {
            this.surrogate.insert(new DBObject[]{dbObject});
        } else {
            this.surrogate.save(dbObject);
        }
    }

    public String getName() {
        return this.surrogate.getName();
    }

    public MongoDatabase getDatabase() {
        return new MongoDatabase(this.surrogate.getDB());
    }

    public MongoView<T> find(Document in) {
        return new MongoView(this.surrogate.find(in.getSurrogate()));
    }

    public CollectionAdministration tools() {
        return new CollectionAdministration(this.surrogate);
    }

    public WriteResult remove(Document filesQuery) {
        return new WriteResult(this.surrogate.remove(filesQuery.getSurrogate()));
    }

    public void createIndex(Document document) {
        this.surrogate.createIndex(document.getSurrogate());
    }
}

