/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb;

import java.util.List;
import org.mongodb.Document;
import org.mongodb.OrderBy;

public final class Index {
    private final String name;
    private final boolean unique;
    private final boolean dropDups;
    private final boolean background;
    private final boolean sparse;
    private final int expireAfterSeconds;
    private final Document keys;
    private final Document extra;

    private Index(String name, boolean unique, boolean dropDups, boolean sparse, boolean background, int expireAfterSeconds, Document keys, Document extra) {
        this.name = name;
        this.unique = unique;
        this.dropDups = dropDups;
        this.sparse = sparse;
        this.background = background;
        this.expireAfterSeconds = expireAfterSeconds;
        this.keys = keys;
        this.extra = extra;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getName() {
        return this.name;
    }

    public boolean isUnique() {
        return this.unique;
    }

    public boolean isDropDups() {
        return this.dropDups;
    }

    public boolean isBackground() {
        return this.background;
    }

    public boolean isSparse() {
        return this.sparse;
    }

    public int getExpireAfterSeconds() {
        return this.expireAfterSeconds;
    }

    public Document getKeys() {
        return this.keys;
    }

    public Document getExtra() {
        return this.extra;
    }

    public static final class Builder {
        private String name;
        private boolean unique = false;
        private boolean dropDups = false;
        private boolean background = false;
        private boolean sparse = false;
        private int expireAfterSeconds = -1;
        private final Document keys = new Document();
        private final Document extra = new Document();

        private Builder() {
        }

        public Builder name(String indexName) {
            this.name = indexName;
            return this;
        }

        public Builder unique() {
            this.unique = true;
            return this;
        }

        public Builder unique(boolean value) {
            this.unique = value;
            return this;
        }

        public Builder dropDups() {
            this.dropDups = true;
            return this;
        }

        public Builder dropDups(boolean value) {
            this.dropDups = value;
            return this;
        }

        public Builder background() {
            this.background = true;
            return this;
        }

        public Builder background(boolean value) {
            this.background = value;
            return this;
        }

        public Builder sparse() {
            this.sparse = true;
            return this;
        }

        public Builder sparse(boolean value) {
            this.sparse = value;
            return this;
        }

        public Builder expireAfterSeconds(int seconds) {
            this.expireAfterSeconds = seconds;
            return this;
        }

        public Builder addKey(String key) {
            return this.addKey(key, OrderBy.ASC);
        }

        public Builder addKeys(String ... keyNames) {
            for (String keyName : keyNames) {
                this.addKey(keyName);
            }
            return this;
        }

        public Builder addKey(String key, OrderBy orderBy) {
            this.keys.put(key, orderBy.getIntRepresentation());
            return this;
        }

        public Builder addKey(Key<?> key) {
            this.keys.put(key.getFieldName(), key.getValue());
            return this;
        }

        public Builder addKeys(Key<?> ... newKeys) {
            for (Key<?> key : newKeys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder addKeys(List<Key<?>> newKeys) {
            for (Key<?> key : newKeys) {
                this.addKey(key);
            }
            return this;
        }

        public Builder extra(String key, Object value) {
            this.extra.put(key, value);
            return this;
        }

        private String generateIndexName() {
            StringBuilder indexName = new StringBuilder();
            for (String string : this.keys.keySet()) {
                if (indexName.length() != 0) {
                    indexName.append('_');
                }
                indexName.append(string).append('_');
                Object ascOrDescValue = this.keys.get(string);
                if (!(ascOrDescValue instanceof Number) && !(ascOrDescValue instanceof String)) continue;
                indexName.append(ascOrDescValue.toString().replace(' ', '_'));
            }
            return indexName.toString();
        }

        public Index build() {
            if (this.name == null) {
                this.name = this.generateIndexName();
            }
            return new Index(this.name, this.unique, this.dropDups, this.sparse, this.background, this.expireAfterSeconds, this.keys, this.extra);
        }
    }

    public static interface Key<T> {
        public String getFieldName();

        public T getValue();
    }

    public static class Text
    implements Key<String> {
        private final String fieldName;

        public Text(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String getValue() {
            return "text";
        }
    }

    public static class GeoKey
    implements Key<String> {
        private final String fieldName;

        public GeoKey(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public String getValue() {
            return "2d";
        }
    }

    public static class OrderedKey
    implements Key<Integer> {
        private final String fieldName;
        private final OrderBy orderBy;

        public OrderedKey(String fieldName, OrderBy orderBy) {
            this.fieldName = fieldName;
            this.orderBy = orderBy;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public Integer getValue() {
            return this.orderBy.getIntRepresentation();
        }
    }
}

