/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Date;
import me.lightspeed7.mongofs.MongoFileConstants;
import org.bson.BSON;
import org.bson.types.ObjectId;

public class Document {
    private DBObject surrogate;

    public Document(String key, Object id) {
        this();
        this.getSurrogate().put(key, this.unwrap(id));
    }

    public Document() {
        this.setSurrogate((DBObject)new BasicDBObject());
    }

    public Document(DBObject incoming) {
        this.setSurrogate(incoming);
    }

    public Document append(String key, Object value) {
        this.getSurrogate().put(key, this.unwrap(value));
        return this;
    }

    public Object put(String key, Object value) {
        return this.getSurrogate().put(key, this.unwrap(value));
    }

    public Object get(String key) {
        return this.wrap(this.getSurrogate().get(key));
    }

    public String getString(MongoFileConstants constant) {
        return this.getString(constant.name());
    }

    public boolean containsKey(String key) {
        return this.getSurrogate().containsKey(key);
    }

    public Collection<? extends String> keySet() {
        return this.getSurrogate().keySet();
    }

    private Object unwrap(Object value) {
        if (value == null || !value.getClass().isAssignableFrom(Document.class)) {
            return value;
        }
        if (value.getClass().isAssignableFrom(Document.class) && value.getClass().isAssignableFrom(Serializable.class)) {
            return value;
        }
        try {
            Field field = value.getClass().getDeclaredField("surrogate");
            field.setAccessible(true);
            return field.get(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("surrogate.surrogate not valid", e);
        }
    }

    private Object wrap(Object value) {
        if (value != null && value.getClass().isAssignableFrom(DBObject.class)) {
            return new Document((DBObject)value);
        }
        return value;
    }

    public int getInt(String key) {
        Object o = this.get(key);
        if (o == null) {
            throw new NullPointerException("no value for: " + key);
        }
        return BSON.toInt((Object)o);
    }

    public int getInt(String key, int def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return BSON.toInt((Object)foo);
    }

    public long getLong(String key) {
        Object foo = this.get(key);
        return ((Number)foo).longValue();
    }

    public long getLong(String key, long def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return ((Number)foo).longValue();
    }

    public double getDouble(String key) {
        Object foo = this.get(key);
        return ((Number)foo).doubleValue();
    }

    public double getDouble(String key, double def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return ((Number)foo).doubleValue();
    }

    public String getString(String key) {
        Object foo = this.get(key);
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public String getString(String key, String def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        return foo.toString();
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean def) {
        Object foo = this.get(key);
        if (foo == null) {
            return def;
        }
        if (foo instanceof Number) {
            return ((Number)foo).intValue() > 0;
        }
        if (foo instanceof Boolean) {
            return (Boolean)foo;
        }
        throw new IllegalArgumentException("can't coerce to bool:" + foo.getClass());
    }

    public ObjectId getObjectId(String field) {
        return (ObjectId)this.get(field);
    }

    public ObjectId getObjectId(String field, ObjectId def) {
        Object foo = this.get(field);
        return foo != null ? (ObjectId)foo : def;
    }

    public Date getDate(String field) {
        return (Date)this.get(field);
    }

    public Date getDate(String field, Date def) {
        Object foo = this.get(field);
        return foo != null ? (Date)foo : def;
    }

    public Integer getInteger(Object key) {
        return (Integer)this.get(key.toString());
    }

    public int getInteger(Object key, int defaultValue) {
        Object value = this.get(key.toString());
        return value == null ? defaultValue : (Integer)value;
    }

    public DBObject getSurrogate() {
        return this.surrogate;
    }

    public void setSurrogate(DBObject surrogate) {
        this.surrogate = surrogate;
    }
}

