/*
 * Decompiled with CFR 0.152.
 */
package org.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.List;
import org.mongodb.Document;
import org.mongodb.Index;

public class CollectionAdministration {
    private DBCollection surrogate;

    public CollectionAdministration(DBCollection surrogate) {
        this.surrogate = surrogate;
    }

    public List<Document> getIndexes() {
        ArrayList<Document> indexes = new ArrayList<Document>();
        for (DBObject dbObject : this.surrogate.getIndexInfo()) {
            indexes.add(new Document(dbObject));
        }
        return indexes;
    }

    public void createIndexes(List<Index> indexes) {
        for (Index index : indexes) {
            BasicDBObject keys = new BasicDBObject();
            Document document = index.getKeys();
            for (String string : document.keySet()) {
                keys.put((Object)string, document.get(string));
            }
            BasicDBObject options = new BasicDBObject();
            options.put((Object)"name", (Object)index.getName());
            if (index.isUnique()) {
                options.put((Object)"unique", (Object)index.isUnique());
            }
            if (index.isSparse()) {
                options.put((Object)"sparse", (Object)index.isSparse());
            }
            if (index.isDropDups()) {
                options.put((Object)"dropDups", (Object)index.isDropDups());
            }
            if (index.isBackground()) {
                options.put((Object)"background", (Object)index.isBackground());
            }
            if (index.getExpireAfterSeconds() != -1) {
                options.put((Object)"expireAfterSeconds", (Object)index.getExpireAfterSeconds());
            }
            this.surrogate.createIndex((DBObject)keys, (DBObject)options);
        }
    }
}

